/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.ModifierNode;
import com.helmpcb.cmsisconfig.NodeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ArithmeticModifier
extends ModifierNode {
    private static final Pattern ARITHMETIC_PATTERN = Pattern.compile("<#([-/+*])((?:0[xX][\\da-fA-F]++)|\\d++)>");
    private char operation;
    private long operationValue;

    public ArithmeticModifier(String tag, String text) throws NodeException {
        super(tag, text);
        this.extractTagInfo();
    }

    private void extractTagInfo() throws NodeException {
        Matcher matcher = ARITHMETIC_PATTERN.matcher(this.tag);
        if (matcher.find()) {
            this.operation = matcher.group(1).charAt(0);
            try {
                this.operationValue = this.ParseNumber(matcher.group(2));
            }
            catch (NumberFormatException ex) {
                throw new NodeException("Invalid field in modifier: " + this.tag);
            }
        } else {
            throw new NodeException("Tag not in expected format: " + this.tag);
        }
    }

    public long getModifiedValueFromTarget(long targetValue) {
        long modifiedValue;
        switch (this.operation) {
            case '+': {
                modifiedValue = targetValue - this.operationValue;
                break;
            }
            case '-': {
                modifiedValue = targetValue + this.operationValue;
                break;
            }
            case '*': {
                modifiedValue = targetValue / this.operationValue;
                break;
            }
            case '/': {
                modifiedValue = targetValue * this.operationValue;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid operator " + this.operation);
            }
        }
        return modifiedValue;
    }

    public long getTargetFromModifiedValue(long modifiedValue) {
        long targetValue;
        switch (this.operation) {
            case '+': {
                targetValue = modifiedValue + this.operationValue;
                break;
            }
            case '-': {
                targetValue = modifiedValue - this.operationValue;
                break;
            }
            case '*': {
                targetValue = modifiedValue * this.operationValue;
                break;
            }
            case '/': {
                targetValue = modifiedValue / this.operationValue;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid operator " + this.operation);
            }
        }
        return targetValue;
    }
}

