/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.CMSISConfigurator;
import com.helmpcb.cmsisconfig.InputNode;
import com.helmpcb.cmsisconfig.NodeException;
import com.helmpcb.cmsisconfig.TargetException;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CMSISConfig
extends JFrame
implements TreeSelectionListener {
    private final String formTitle = "CMSIS Configurator";
    private final String versionString = "v0.0.7";
    private final JFileChooser fileChooser = new JFileChooser();
    private CMSISConfigurator configurator;
    private File currentFile;
    private JButton btnCollapse;
    private JButton btnExpand;
    private JButton btnOpen;
    private JButton btnSave;
    private JPanel editorPanel;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar jToolBar1;
    private JMenuItem mnuAbout;
    private JMenuItem mnuExit;
    private JMenu mnuHelp;
    private JMenuItem mnuOpen;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveAs;
    private JTree tree;

    public CMSISConfig(File fileToOpen) {
        this.initComponents();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Source files (*.c, *.h, *.s, *.inc)", "c", "h", "s", "inc");
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileToOpen != null) {
            this.currentFile = fileToOpen;
            this.openFile();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.editorPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.btnOpen = new JButton();
        this.btnSave = new JButton();
        this.btnExpand = new JButton();
        this.btnCollapse = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuOpen = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnuSave = new JMenuItem();
        this.mnuSaveAs = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnuExit = new JMenuItem();
        this.mnuHelp = new JMenu();
        this.mnuAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("CMSIS Configurator");
        this.setIconImage(new ImageIcon(this.getClass().getResource("ConfigWizardProgramIcon.png")).getImage());
        this.setLocationByPlatform(true);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.jScrollPane1.setViewportView(this.tree);
        this.editorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setToolTipText("");
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/com/helmpcb/cmsisconfig/folder_open.png")));
        this.btnOpen.setToolTipText("Open...");
        this.btnOpen.setFocusable(false);
        this.btnOpen.setHorizontalTextPosition(0);
        this.btnOpen.setVerticalTextPosition(3);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.btnOpenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnOpen);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/helmpcb/cmsisconfig/save.png")));
        this.btnSave.setToolTipText("Save");
        this.btnSave.setEnabled(false);
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.btnSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSave);
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/com/helmpcb/cmsisconfig/bullet_toggle_plus.png")));
        this.btnExpand.setToolTipText("Expand all nodes");
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalTextPosition(0);
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.btnExpandActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExpand);
        this.btnCollapse.setIcon(new ImageIcon(this.getClass().getResource("/com/helmpcb/cmsisconfig/bullet_toggle_minus.png")));
        this.btnCollapse.setToolTipText("Collapse all nodes");
        this.btnCollapse.setFocusable(false);
        this.btnCollapse.setHorizontalTextPosition(0);
        this.btnCollapse.setVerticalTextPosition(3);
        this.btnCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.btnCollapseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCollapse);
        this.jMenu1.setText("File");
        this.mnuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mnuOpen.setText("Open...");
        this.mnuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.mnuOpenActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuOpen);
        this.jMenu1.add(this.jSeparator1);
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mnuSave.setText("Save");
        this.mnuSave.setEnabled(false);
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.mnuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSave);
        this.mnuSaveAs.setText("Save As...");
        this.mnuSaveAs.setEnabled(false);
        this.mnuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.mnuSaveAsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSaveAs);
        this.jMenu1.add(this.jSeparator2);
        this.mnuExit.setText("Exit");
        this.mnuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.mnuExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuExit);
        this.jMenuBar1.add(this.jMenu1);
        this.mnuHelp.setText("Help");
        this.mnuAbout.setText("About...");
        this.mnuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CMSISConfig.this.mnuAboutActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuAbout);
        this.jMenuBar1.add(this.mnuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 428, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 294, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.editorPanel, -2, 37, -2).addContainerGap()));
        this.pack();
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        try {
            this.configurator.saveFile(this.currentFile);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to save file. " + ex.toString());
        }
    }

    private void openFile() {
        this.setTitle("CMSIS Configurator - " + this.currentFile.getName());
        this.tree.setModel(null);
        try {
            this.configurator = new CMSISConfigurator(this.currentFile);
            this.tree.setModel(new DefaultTreeModel(this.configurator.topNode));
            this.tree.addTreeSelectionListener(this);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.mnuSave.setEnabled(true);
            this.mnuSaveAs.setEnabled(true);
            this.btnSave.setEnabled(true);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Unable to find file '" + this.fileChooser.getSelectedFile().getName() + "'. " + ex.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to open file. " + ex.toString());
        }
        catch (NodeException ex) {
            JOptionPane.showMessageDialog(this, "Error while parsing a node: " + ex.toString());
        }
        catch (TargetException ex) {
            JOptionPane.showMessageDialog(this, "Error while parsing a target value: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(this, ex.toString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unable to parse file: " + ex.toString());
        }
    }

    private void mnuOpenActionPerformed(ActionEvent evt) {
        int retval = this.fileChooser.showOpenDialog(this);
        if (retval == 0) {
            this.currentFile = this.fileChooser.getSelectedFile();
            this.openFile();
        }
    }

    private void mnuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.mnuSaveActionPerformed(evt);
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.mnuOpenActionPerformed(evt);
    }

    private void mnuAboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "CMSIS Configurator v0.0.7\nBy Amr Bekhit\nhttp://www.helmpcb.com");
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void btnCollapseActionPerformed(ActionEvent evt) {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    private void mnuSaveAsActionPerformed(ActionEvent evt) {
        int retval = this.fileChooser.showSaveDialog(this);
        if (retval == 0) {
            this.currentFile = this.fileChooser.getSelectedFile();
            this.mnuSaveActionPerformed(evt);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CMSISConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CMSISConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CMSISConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CMSISConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        final String[] args_copy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File fileToOpen = null;
                if (args_copy.length > 0 && (!(fileToOpen = new File(args_copy[0])).exists() || fileToOpen.isDirectory())) {
                    System.err.println("Unable to open " + args_copy[0]);
                    System.exit(1);
                }
                new CMSISConfig(fileToOpen).setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.editorPanel.removeAll();
        try {
            if (node != null && node instanceof InputNode) {
                this.editorPanel.add(((InputNode)node).getControl());
            }
        }
        catch (IndexOutOfBoundsException ex) {
            JOptionPane.showMessageDialog(this, "Unable to find target for this node.");
        }
        finally {
            this.editorPanel.revalidate();
            this.editorPanel.repaint();
        }
    }
}

