/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.EscapeNode;
import com.helmpcb.cmsisconfig.ModifierNode;
import com.helmpcb.cmsisconfig.ModifyableInputNode;
import com.helmpcb.cmsisconfig.Node;
import com.helmpcb.cmsisconfig.NodeException;
import com.helmpcb.cmsisconfig.NumericOption;
import com.helmpcb.cmsisconfig.NumericTarget;
import com.helmpcb.cmsisconfig.StringTarget;
import com.helmpcb.cmsisconfig.Target;
import com.helmpcb.cmsisconfig.TargetException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;

class CMSISConfigurator {
    private StringBuilder sourceFile = new StringBuilder();
    private final String CONFIG_WIZARD_START_STRING = "<<< Use Configuration Wizard in Context Menu >>>";
    private final String CONFIG_WIZARD_END_STRING = "<<< end of configuration section >>>";
    public DefaultMutableTreeNode topNode;
    private String fileName;
    private String cCommentRegex = "/\\*(?:[^*]|\\*(?!/))*+\\*/|//.*";
    private String assemblerCommentRegex = ";.*+";
    private String itemsOfInterestRegex = "\"(?:[^\"\\\\\\r\\n]|\\\\.)*+\"|(?:\\b|-)(?<!\\.)\\d++(?!\\.)(?:[uUlL]|[uU][lL]|[lL][uU])?\\b|\\b0[xX][\\da-fA-F]+(?:[uUlL]|[uU][lL]|[lL][uU])?\\b";
    private Pattern itemsOfInterestPattern;

    public CMSISConfigurator(File file) throws FileNotFoundException, IOException, NodeException, TargetException {
        this.loadFile(file);
    }

    private void loadFile(File file) throws FileNotFoundException, IOException, NodeException, TargetException {
        String commentRegex;
        byte[] buffer = new byte[(int)file.length()];
        BufferedInputStream r = new BufferedInputStream(new FileInputStream(file));
        r.read(buffer);
        r.close();
        this.sourceFile = new StringBuilder(new String(buffer));
        String extension = this.getExtension(file.getName()).toLowerCase();
        if (extension.equals("c") || extension.equals("h")) {
            commentRegex = this.cCommentRegex;
        } else if (extension.equals("s") || extension.equals("inc")) {
            commentRegex = this.assemblerCommentRegex;
        } else {
            throw new IllegalArgumentException("File is neither an assembler or C source file (based on extension)");
        }
        this.itemsOfInterestPattern = Pattern.compile(commentRegex + "|" + this.itemsOfInterestRegex);
        this.parseFile();
        this.fileName = file.getName();
    }

    public void saveFile(File file) throws IOException {
        StringBuffer outputFile = new StringBuffer();
        ArrayList<Target> targetList = new ArrayList<Target>();
        targetList.addAll(Node.StringTargets);
        targetList.addAll(Node.NumericTargets);
        Matcher matcher = this.itemsOfInterestPattern.matcher(this.sourceFile);
        int matchNumber = 0;
        block0: while (matcher.find()) {
            ++matchNumber;
            for (Target t : targetList) {
                if (t.getMatchNumber() != matchNumber) continue;
                matcher.appendReplacement(outputFile, Matcher.quoteReplacement(t.toString()));
                targetList.remove(t);
                continue block0;
            }
        }
        matcher.appendTail(outputFile);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(outputFile.toString());
        writer.close();
    }

    private void parseFile() throws NodeException, TargetException {
        Node.NumericTargets.clear();
        Node.StringTargets.clear();
        DefaultMutableTreeNode lastNodeInTree = this.topNode = new DefaultMutableTreeNode(this.fileName);
        boolean insideConfigWizardSection = false;
        boolean finishedConfigWizard = false;
        Matcher itemsOfInterestMatcher = this.itemsOfInterestPattern.matcher(this.sourceFile);
        int matchNumber = 0;
        block4: while (itemsOfInterestMatcher.find()) {
            ++matchNumber;
            String token = itemsOfInterestMatcher.group();
            block0 : switch (token.charAt(0)) {
                case '\"': {
                    Node.StringTargets.add(new StringTarget(matchNumber, token));
                    break;
                }
                case '/': 
                case ';': {
                    String[] lines;
                    if (finishedConfigWizard) continue block4;
                    for (String line : lines = token.split("[\\r\\n]")) {
                        if (!insideConfigWizardSection) {
                            if (!line.contains("<<< Use Configuration Wizard in Context Menu >>>")) continue;
                            insideConfigWizardSection = true;
                            continue;
                        }
                        if (line.contains("<<< end of configuration section >>>")) {
                            finishedConfigWizard = true;
                            break block0;
                        }
                        lastNodeInTree = this.extractNodes(line, lastNodeInTree);
                    }
                    continue block4;
                }
                default: {
                    Node.NumericTargets.add(new NumericTarget(matchNumber, token));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultMutableTreeNode extractNodes(String line, DefaultMutableTreeNode lastNodeInTree) throws NodeException {
        Pattern tagPattern = Pattern.compile("(<[^<>\\n\\r]*>)([^<\\r\\n]*)");
        Matcher tagMatcher = tagPattern.matcher(line);
        while (tagMatcher.find()) {
            void var5_5;
            Node node = Node.generate(tagMatcher.group(1), tagMatcher.group(2).trim());
            if (node == null) continue;
            if (node instanceof ModifierNode) {
                if (!(lastNodeInTree instanceof ModifyableInputNode)) throw new NodeException("Modifier " + tagMatcher.group(1) + " has an invalid parent " + lastNodeInTree);
                ((NumericOption)lastNodeInTree).addModifier((ModifierNode)node);
                DefaultMutableTreeNode defaultMutableTreeNode = lastNodeInTree;
            } else if (node instanceof EscapeNode) {
                if (lastNodeInTree.getAllowsChildren()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)lastNodeInTree.getParent();
                } else {
                    if (!((DefaultMutableTreeNode)lastNodeInTree.getParent()).getAllowsChildren()) throw new NodeException("Escape " + tagMatcher.group(1) + " does not close a valid tag");
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)lastNodeInTree.getParent()).getParent();
                }
            } else if (lastNodeInTree.getAllowsChildren()) {
                lastNodeInTree.add(node);
            } else {
                if (!((DefaultMutableTreeNode)lastNodeInTree.getParent()).getAllowsChildren()) throw new NodeException("Unable to find parent to add node " + tagMatcher.group(1) + " to.");
                ((DefaultMutableTreeNode)lastNodeInTree.getParent()).add(node);
            }
            lastNodeInTree = var5_5;
        }
        return lastNodeInTree;
    }

    private String getExtension(String name) {
        String extension = "";
        int extLocation = name.lastIndexOf(".");
        if (extLocation != -1) {
            extension = name.substring(extLocation + 1);
        }
        return extension;
    }
}

