/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.Node;
import com.helmpcb.cmsisconfig.NodeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

abstract class InputNode
extends Node {
    protected JComponent control;
    protected int skipValue;
    protected int startBit;
    private static final Pattern NODE_CONTENTS_PATTERN = Pattern.compile("<\\w(\\d*+)(?:\\.(\\d++)(?:\\.{2}(\\d++))?)?>");
    protected TagInfo tagInfo = this.extractTagInfo();

    public InputNode(String tag, String text) throws NodeException {
        super(tag, text);
        this.skipValue = this.tagInfo.getSkipValue();
        this.startBit = this.tagInfo.getStartBit();
    }

    public int getSkipValue() {
        return this.skipValue;
    }

    private TagInfo extractTagInfo() throws NodeException {
        TagInfo info = new TagInfo();
        Matcher matcher = NODE_CONTENTS_PATTERN.matcher(this.tag);
        if (matcher.find()) {
            for (int g = 1; g <= matcher.groupCount(); ++g) {
                String token = matcher.group(g);
                if (token == null || token.trim().isEmpty()) {
                    ((TagInfo)info).values[g - 1] = -1;
                    continue;
                }
                try {
                    ((TagInfo)info).values[g - 1] = Integer.parseInt(token);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new NodeException("Invalid value for item " + g + " in node " + this.tag);
                }
            }
        } else {
            throw new NodeException("Node not in the expected format: " + this.tag);
        }
        return info;
    }

    public abstract JComponent getControl();

    protected class TagInfo {
        private int[] values = new int[3];

        protected TagInfo() {
        }

        public int getSkipValue() {
            return this.values[0] == -1 ? 0 : this.values[0];
        }

        public int getStartBit() {
            return this.values[1];
        }

        public int getEndBit() {
            return this.values[2];
        }
    }
}

