/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.ArithmeticModifier;
import com.helmpcb.cmsisconfig.EscapeNode;
import com.helmpcb.cmsisconfig.HeadingNode;
import com.helmpcb.cmsisconfig.HeadingWithEnable;
import com.helmpcb.cmsisconfig.InputNode;
import com.helmpcb.cmsisconfig.NodeException;
import com.helmpcb.cmsisconfig.NumericOption;
import com.helmpcb.cmsisconfig.NumericRangeModifier;
import com.helmpcb.cmsisconfig.NumericTarget;
import com.helmpcb.cmsisconfig.OptionWithCheckbox;
import com.helmpcb.cmsisconfig.SelectionValueModifier;
import com.helmpcb.cmsisconfig.StringOption;
import com.helmpcb.cmsisconfig.StringTarget;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

abstract class Node
extends DefaultMutableTreeNode {
    protected String tag;
    protected String text;
    protected String tooltip;
    public static ArrayList<NumericTarget> NumericTargets = new ArrayList();
    public static ArrayList<StringTarget> StringTargets = new ArrayList();

    public static Node generate(String tag, String text) throws NodeException {
        char identifier = tag.charAt(1);
        switch (identifier) {
            case 'h': {
                return new HeadingNode(tag, text);
            }
            case 'e': {
                return new HeadingWithEnable(tag, text);
            }
            case 'q': {
                return new OptionWithCheckbox(tag, text);
            }
            case 'o': {
                return new NumericOption(tag, text);
            }
            case 's': {
                return new StringOption(tag, text);
            }
            case '#': {
                return new ArithmeticModifier(tag, text);
            }
            case '/': {
                return new EscapeNode(tag, text);
            }
        }
        if (Character.isDigit(identifier)) {
            if (tag.indexOf(61) != -1) {
                return new SelectionValueModifier(tag, text);
            }
            return new NumericRangeModifier(tag, text);
        }
        return null;
    }

    public Node(String tag, String text) {
        this.tag = tag;
        this.text = text;
    }

    public void addToolTip(String tooltip) {
        this.tooltip = this.tooltip + tooltip;
    }

    @Override
    public String toString() {
        return this.text;
    }

    public static class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof InputNode) {
                // empty if block
            }
            this.setText(value.toString());
            return this;
        }
    }
}

