/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.ArithmeticModifier;
import com.helmpcb.cmsisconfig.ModifierNode;
import com.helmpcb.cmsisconfig.ModifyableInputNode;
import com.helmpcb.cmsisconfig.Node;
import com.helmpcb.cmsisconfig.NodeException;
import com.helmpcb.cmsisconfig.NumericRangeModifier;
import com.helmpcb.cmsisconfig.SelectionValueModifier;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

class NumericOption
extends ModifyableInputNode
implements ItemListener,
ChangeListener {
    private int endBit;
    private ArrayList<SelectionValueModifier> SelectionValues = new ArrayList();
    private NumericRangeModifier numericRangeModifier;
    private ArithmeticModifier arithmeticModifier = new ArithmeticModifier("<#*1>", "");

    public NumericOption(String tag, String text) throws NodeException {
        super(tag, text);
        this.allowsChildren = false;
        this.skipValue += Node.NumericTargets.size();
        this.endBit = this.tagInfo.getEndBit();
        if (this.endBit != -1 && this.endBit <= this.startBit) {
            throw new NodeException("End bit cannot be smaller than start bit: " + tag);
        }
    }

    @Override
    public void addModifier(ModifierNode modifier) throws NodeException {
        if (modifier instanceof ArithmeticModifier) {
            this.arithmeticModifier = (ArithmeticModifier)modifier;
        } else if (modifier instanceof NumericRangeModifier) {
            if (this.SelectionValues.size() > 0) {
                throw new NodeException("Cannot add numeric range modifier '" + modifier.tag + "' to numeric option '" + this.tag + "' with selection values.");
            }
            this.numericRangeModifier = (NumericRangeModifier)modifier;
        } else if (modifier instanceof SelectionValueModifier) {
            if (this.numericRangeModifier != null) {
                throw new NodeException("Cannot add selection value '" + modifier.tag + ":" + modifier.text + "' to a node with a numeric range modifier.");
            }
            this.SelectionValues.add((SelectionValueModifier)modifier);
        } else {
            throw new NodeException("Unknown modifier " + modifier.tag);
        }
    }

    private void generateControl() {
        if (this.SelectionValues.size() > 0) {
            JComboBox<SelectionValueModifier> comboBox = new JComboBox<SelectionValueModifier>(this.SelectionValues.toArray(new SelectionValueModifier[0]));
            comboBox.addItemListener(this);
            this.control = comboBox;
        } else if (this.startBit >= 0 && this.endBit < 0) {
            JCheckBox checkBox = new JCheckBox(this.text);
            checkBox.addItemListener(this);
            this.control = checkBox;
        } else {
            Long stepValue;
            Long maxValue;
            Long minValue;
            if (this.numericRangeModifier != null) {
                minValue = this.numericRangeModifier.getRangeStart();
                maxValue = this.numericRangeModifier.getRangeStop();
                stepValue = this.numericRangeModifier.getRangeStep();
            } else {
                minValue = 0L;
                maxValue = 0xFFFFFFFFL;
                stepValue = 1L;
            }
            Long initialValue = this.arithmeticModifier.getModifiedValueFromTarget(Node.NumericTargets.get(this.skipValue).getValue(this.startBit, this.endBit));
            if (initialValue < minValue) {
                initialValue = minValue;
            } else if (initialValue > maxValue) {
                initialValue = maxValue;
            }
            SpinnerNumberModel model = new SpinnerNumberModel(initialValue, minValue, maxValue, stepValue);
            JSpinner spinner = new JSpinner(model);
            spinner.addChangeListener(this);
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
            editor.getTextField().setColumns(15);
            if (this.numericRangeModifier == null || this.numericRangeModifier.isHexadecimal()) {
                editor.getTextField().setFormatterFactory(new HexFormatterFactory());
            }
            this.control = spinner;
        }
    }

    @Override
    public JComponent getControl() {
        if (this.control == null) {
            this.generateControl();
        }
        this.updateControl();
        return this.control;
    }

    private void updateControl() {
        long modifiedValue = this.arithmeticModifier.getModifiedValueFromTarget(Node.NumericTargets.get(this.skipValue).getValue(this.startBit, this.endBit));
        if (this.control instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)this.control;
            int matchingIndex = this.findMatchingSelectionValueModifier(modifiedValue);
            if (matchingIndex >= 0) {
                comboBox.setSelectedIndex(matchingIndex);
            } else {
                comboBox.setBackground(Color.pink);
                comboBox.setSelectedIndex(0);
            }
        } else if (this.control instanceof JSpinner) {
            JSpinner spinner = (JSpinner)this.control;
            SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
            if (modifiedValue < (Long)model.getMinimum()) {
                modifiedValue = (Long)model.getMinimum();
            } else if (modifiedValue > (Long)model.getMaximum()) {
                modifiedValue = (Long)model.getMaximum();
            }
            spinner.setValue(modifiedValue);
        } else if (this.control instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)this.control;
            checkBox.setSelected(Node.NumericTargets.get(this.skipValue).getValue(this.startBit) != 0L);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.control instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)this.control;
            SelectionValueModifier selectedValue = (SelectionValueModifier)comboBox.getSelectedItem();
            Node.NumericTargets.get(this.skipValue).setValue(this.arithmeticModifier.getTargetFromModifiedValue(selectedValue.getValue()), this.startBit, this.endBit);
        } else if (this.control instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)this.control;
            if (checkBox.isSelected()) {
                Node.NumericTargets.get(this.skipValue).setValue(1L, this.startBit);
            } else {
                Node.NumericTargets.get(this.skipValue).setValue(0L, this.startBit);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)this.control;
        Node.NumericTargets.get(this.skipValue).setValue(this.arithmeticModifier.getTargetFromModifiedValue((Long)spinner.getValue()), this.startBit, this.endBit);
    }

    private int findMatchingSelectionValueModifier(long value) {
        int matchingIndex = -1;
        for (int i = 0; i < this.SelectionValues.size(); ++i) {
            if (this.SelectionValues.get(i).getValue() != value) continue;
            matchingIndex = i;
            break;
        }
        return matchingIndex;
    }

    private class HexFormatter
    extends DefaultFormatter {
        private HexFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            try {
                return Long.valueOf(text, 16);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(text, 0);
            }
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            return Long.toHexString((Long)value).toUpperCase();
        }
    }

    private class HexFormatterFactory
    extends DefaultFormatterFactory {
        private HexFormatterFactory() {
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            return new HexFormatter();
        }
    }
}

