/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.ModifierNode;
import com.helmpcb.cmsisconfig.NodeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NumericRangeModifier
extends ModifierNode {
    private static final Pattern NUMERIC_RANGE_PATTERN = Pattern.compile("<((?:0[xX][\\da-fA-F]++)|\\d++)-((?:0[xX][\\da-fA-F]++)|\\d++)(?::((?:0[xX][\\da-fA-F]++)|\\d++))?>");
    private long rangeStart;
    private long rangeStop;
    private long rangeStep;

    public NumericRangeModifier(String tag, String text) throws NodeException {
        super(tag, text);
        this.extractTagInfo();
    }

    private void extractTagInfo() throws NodeException {
        Matcher matcher = NUMERIC_RANGE_PATTERN.matcher(this.tag);
        if (matcher.find()) {
            try {
                this.rangeStart = this.ParseNumber(matcher.group(1));
                this.rangeStop = this.ParseNumber(matcher.group(2));
                if (matcher.group(3) != null) {
                    this.rangeStep = this.ParseNumber(matcher.group(3));
                }
                this.rangeStep = 1L;
            }
            catch (NumberFormatException ex) {
                throw new NodeException("Invalid field in modifier: " + this.tag);
            }
        } else {
            throw new NodeException("Tag not in expected format: " + this.tag);
        }
    }

    public long getRangeStart() {
        return this.rangeStart;
    }

    public long getRangeStop() {
        return this.rangeStop;
    }

    public long getRangeStep() {
        return this.rangeStep;
    }
}

