/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.Target;
import com.helmpcb.cmsisconfig.TargetException;

class NumericTarget
extends Target {
    private boolean isHexadecimal;
    private long value;
    private String suffix = "";

    public NumericTarget(int matchNumber, String stringValue) throws TargetException {
        super(matchNumber, stringValue);
        if (stringValue.length() >= 2) {
            String lastTwoLetters = stringValue.substring(stringValue.length() - 2);
            char lastLetter = lastTwoLetters.toUpperCase().charAt(1);
            char nextToLastLetter = lastTwoLetters.toUpperCase().charAt(0);
            if (lastLetter == 'U' || lastLetter == 'L') {
                if (nextToLastLetter == 'U' || nextToLastLetter == 'L') {
                    this.suffix = lastTwoLetters;
                    stringValue = stringValue.substring(0, stringValue.length() - 2);
                } else {
                    this.suffix = "" + lastTwoLetters.charAt(1);
                    stringValue = stringValue.substring(0, stringValue.length() - 1);
                }
            }
        }
        try {
            if (stringValue.length() > 2 && stringValue.toLowerCase().charAt(1) == 'x') {
                this.isHexadecimal = true;
                this.value = Long.parseLong(stringValue.substring(2), 16);
            } else {
                this.isHexadecimal = false;
                this.value = Long.parseLong(stringValue);
            }
        }
        catch (NumberFormatException ex) {
            throw new TargetException("Unable to convert target '" + stringValue + "' to a number.");
        }
    }

    public long getValue() {
        return this.getValue(-1, -1);
    }

    public long getValue(int startBit) {
        return this.getValue(startBit, -1);
    }

    public long getValue(int startBit, int endBit) {
        this.validateBitRange(startBit, endBit);
        if (startBit < 0) {
            return this.value;
        }
        if (endBit < 0) {
            return (this.value & 1L << startBit) == 0L ? 0L : 1L;
        }
        int maskWidth = endBit - startBit + 1;
        long mask = (1L << maskWidth) - 1L << startBit;
        return (this.value & mask) >> startBit;
    }

    public void setValue(long value) {
        this.setValue(value, -1, -1);
    }

    public void setValue(long value, int startBit) {
        this.setValue(value, startBit, -1);
    }

    public void setValue(long value, int startBit, int endBit) {
        this.validateBitRange(startBit, endBit);
        this.value = startBit < 0 ? value : (endBit < 0 ? (value == 0L ? this.clearBit(this.value, startBit) : this.setBit(this.value, startBit)) : this.applyBitmap(value, startBit, endBit));
    }

    public void parseStringValue(String stringValue, int startBit, int endBit) throws TargetException {
        long numericValue;
        try {
            if (stringValue.length() > 2 && stringValue.toLowerCase().charAt(1) == 'x') {
                numericValue = Long.parseLong(stringValue.substring(2), 16);
            } else {
                try {
                    numericValue = Long.parseLong(stringValue);
                }
                catch (NumberFormatException ex) {
                    numericValue = Long.parseLong(stringValue, 16);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new TargetException("Invalid number " + stringValue);
        }
        this.setValue(numericValue, startBit, endBit);
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(-1, -1);
    }

    public String getStringValue(int startBit, int endBit) {
        long numericValue = this.getValue(startBit, endBit);
        if (this.isHexadecimal) {
            return "0x" + Long.toHexString(numericValue).toUpperCase();
        }
        return Long.toString(numericValue);
    }

    public String toString() {
        return this.getStringValue() + this.suffix;
    }

    private long setBit(long value, int bit) {
        if (bit < 0) {
            throw new ArithmeticException("Invalid bit position " + bit);
        }
        return value | 1L << bit;
    }

    private long clearBit(long value, int bit) {
        if (bit < 0) {
            throw new ArithmeticException("Invalid bit position " + bit);
        }
        return value & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private long applyBitmap(long value, int startBit, int endBit) {
        int maskWidth = endBit - startBit + 1;
        long mask = (1L << maskWidth) - 1L << startBit;
        return this.value ^ (this.value ^ (value <<= startBit)) & mask;
    }

    private void validateBitRange(int startBit, int endBit) {
        if (startBit < 0 && endBit >= 0 || endBit >= 0 && startBit >= endBit) {
            throw new ArithmeticException("Invalid bit range: " + startBit + " - " + endBit);
        }
    }
}

