/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.ModifierNode;
import com.helmpcb.cmsisconfig.NodeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SelectionValueModifier
extends ModifierNode {
    private static final Pattern SELECTION_PATTERN = Pattern.compile("<((?:0[xX][\\da-fA-F]++)|\\d++)=>");
    private long value;

    public SelectionValueModifier(String tag, String text) throws NodeException {
        super(tag, text);
        this.extractTagInfo();
    }

    private void extractTagInfo() throws NodeException {
        Matcher matcher = SELECTION_PATTERN.matcher(this.tag);
        if (matcher.find()) {
            try {
                this.value = this.ParseNumber(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                throw new NodeException("Invalid number in modifier: " + this.tag);
            }
        } else {
            throw new NodeException("Tag not in expected format: " + this.tag);
        }
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.text;
    }
}

