/*
 * Decompiled with CFR 0.152.
 */
package com.helmpcb.cmsisconfig;

import com.helmpcb.cmsisconfig.InputNode;
import com.helmpcb.cmsisconfig.Node;
import com.helmpcb.cmsisconfig.NodeException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class StringOption
extends InputNode {
    public StringOption(String tag, String text) throws NodeException {
        super(tag, text);
        this.allowsChildren = false;
        this.skipValue += Node.StringTargets.size();
        this.generateControl();
    }

    public int getMaxStringSize() {
        return this.startBit;
    }

    private void generateControl() {
        JTextField textField = new JTextField(30);
        textField.getDocument().addDocumentListener(new TextFieldDocumentListener());
        this.control = textField;
    }

    @Override
    public JComponent getControl() {
        JTextField textField = (JTextField)this.control;
        textField.setText(Node.StringTargets.get(this.skipValue).getStringValue());
        return this.control;
    }

    private class TextFieldDocumentListener
    implements DocumentListener {
        private TextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateStringTarget();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateStringTarget();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void updateStringTarget() {
            JTextField textField = (JTextField)StringOption.this.control;
            Node.StringTargets.get(StringOption.this.skipValue).setValue(textField.getText());
        }
    }
}

