/**
  ******************************************************************************
  * @file    TestUserFunctions.cpp
  * @authors  Zachary Crockett
  * @version V1.0.0
  * @date    10-Jan-2014
  * @brief   User Function Tests
  ******************************************************************************
  Copyright (c) 2014-2015 Particle Industries, Inc.  All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation, either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, see <http://www.gnu.org/licenses/>.
  ******************************************************************************
  */

#include "UnitTest++.h"
#include "core_protocol.h"
#include "ConstructorFixture.h"

SUITE(UserFunctions)
{
  TEST_FIXTURE(ConstructorFixture, ArgLen63Succeeds)
  {
    uint8_t function_call[82] = {
      0x00, 0x50,
      0x94, 0x57, 0x84, 0x8C, 0xDF, 0x53, 0xC1, 0xC2,
      0xF3, 0x59, 0x0C, 0x64, 0xDF, 0xBB, 0x19, 0xB1,
      0x58, 0x55, 0x63, 0x4D, 0x4C, 0x5F, 0x83, 0xA4,
      0xC9, 0x5B, 0x0A, 0x94, 0xDA, 0x62, 0x58, 0x58,
      0x58, 0x1E, 0x17, 0xED, 0x66, 0x0A, 0x3E, 0xEB,
      0x12, 0x10, 0x4C, 0x91, 0x1B, 0xCE, 0x7B, 0x5A,
      0x92, 0xD0, 0x00, 0x45, 0x91, 0x28, 0x5A, 0x99,
      0xE0, 0xAD, 0x43, 0x24, 0x28, 0x46, 0xB6, 0x94,
      0x30, 0x80, 0x6C, 0xD8, 0xF9, 0x0D, 0x15, 0x6F,
      0xFD, 0x5E, 0xCE, 0xB2, 0xFE, 0x57, 0xE8, 0xE3 };
    memcpy(message_to_receive, function_call, 82);
    spark_protocol.handshake();
    bytes_received[0] = bytes_sent[0] = 0;
    bool success = spark_protocol.event_loop();
    CHECK(success);
  }

  TEST_FIXTURE(ConstructorFixture, ArgLen64Fails)
  {
    uint8_t function_call[82] = {
      0x00, 0x50,
      0x46, 0xE5, 0xBA, 0xEB, 0xD5, 0x31, 0xA3, 0x03,
      0x42, 0x59, 0x19, 0x08, 0x35, 0xCF, 0xC1, 0x63,
      0xF0, 0xED, 0x7F, 0x75, 0x39, 0xFF, 0x6E, 0xDD,
      0x6E, 0xD1, 0x50, 0xA2, 0xAC, 0xC0, 0x39, 0x77,
      0xA3, 0x06, 0x70, 0x88, 0xF8, 0xAC, 0x68, 0x69,
      0xCA, 0xCD, 0xAC, 0x7B, 0x62, 0x74, 0xAF, 0x53,
      0x3E, 0xE2, 0xC4, 0x21, 0x07, 0x8C, 0x67, 0xD1,
      0x3E, 0x2D, 0x6A, 0x76, 0x70, 0x2D, 0x57, 0x55,
      0x82, 0x89, 0xD0, 0xC2, 0xB9, 0x8E, 0x1C, 0xE2,
      0x6E, 0xE3, 0x5E, 0x20, 0xC2, 0x7B, 0x19, 0x1D };
    memcpy(message_to_receive, function_call, 82);
    spark_protocol.handshake();
    bytes_received[0] = bytes_sent[0] = 0;
    bool success = spark_protocol.event_loop();
    CHECK(!success);
  }
}
