/****************************************************************************
 * libnx/nxfonts/nxfonts_serif38x48.h
 *
 *   Copyright (C) 2011-2012 NX Engineering, S.A., All rights reserved.
 *   Author: Jose Pablo Carballo Gomez <jcarballo@nx-engineering.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT}
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING}
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __LIBNX_NXFONTS_NXFONTS_SERIF38X48_H
#define __LIBNX_NXFONTS_NXFONTS_SERIF38X48_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SERIF38X48

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  48
#define NXFONT_MAXWIDTH   38

/* The width of a space */

#define NXFONT_SPACEWIDTH 8

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 4, 23, 3, 14, 0}
#define NXFONT_BITMAP_33 {0x60, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x60}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {2, 9, 7, 2, 14, 0}
#define NXFONT_BITMAP_34 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_35 {0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x6, 0x18, 0x7f, 0xff, 0x7f, 0xff, 0xc, 0x30, 0xc, 0x30, 0xc, 0x30, 0xc, 0x30, 0xff, 0xfe, 0xff, 0xfe, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 13, 28, 2, 12, 0}
#define NXFONT_BITMAP_36 {0x2, 0x0, 0x2, 0x0, 0xf, 0xc0, 0x3a, 0x70, 0x32, 0x38, 0x62, 0x18, 0x62, 0x8, 0x62, 0x8, 0x72, 0x0, 0x7a, 0x0, 0x3e, 0x0, 0x3f, 0x0, 0x1f, 0x80, 0x7, 0xc0, 0x3, 0xe0, 0x2, 0xf0, 0x2, 0x70, 0x2, 0x38, 0x2, 0x38, 0x82, 0x18, 0x82, 0x18, 0xc2, 0x38, 0xe2, 0x30, 0x72, 0x60, 0x1f, 0xc0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {3, 23, 23, 2, 14, 0}
#define NXFONT_BITMAP_37 {0xf, 0x0, 0x40, 0x1d, 0x83, 0xc0, 0x38, 0xfc, 0x80, 0x70, 0x41, 0x80, 0x70, 0x43, 0x0, 0xe0, 0x42, 0x0, 0xe0, 0x46, 0x0, 0xe0, 0xc4, 0x0, 0xc0, 0x8c, 0x0, 0xc1, 0x88, 0x0, 0xc1, 0x18, 0x78, 0x66, 0x10, 0xec, 0x3c, 0x31, 0xc6, 0x0, 0x63, 0x82, 0x0, 0x43, 0x82, 0x0, 0xc7, 0x2, 0x0, 0x87, 0x2, 0x1, 0x87, 0x6, 0x1, 0x6, 0x4, 0x3, 0x6, 0xc, 0x2, 0x6, 0x8, 0x6, 0x3, 0x30, 0x4, 0x1, 0xe0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 23, 23, 2, 14, 0}
#define NXFONT_BITMAP_38 {0x0, 0xf8, 0x0, 0x1, 0x8c, 0x0, 0x3, 0xe, 0x0, 0x3, 0x6, 0x0, 0x7, 0x6, 0x0, 0x7, 0x6, 0x0, 0x7, 0xc, 0x0, 0x7, 0x8c, 0x0, 0x3, 0x98, 0x0, 0x3, 0xf1, 0xfc, 0x3, 0xc0, 0x70, 0x7, 0xc0, 0x60, 0x1d, 0xe0, 0x40, 0x38, 0xf0, 0xc0, 0x70, 0x70, 0x80, 0x60, 0x79, 0x80, 0xe0, 0x3f, 0x0, 0xe0, 0x1e, 0x0, 0xe0, 0xf, 0x0, 0xf0, 0x1f, 0x82, 0x78, 0x33, 0xfc, 0x7f, 0xe1, 0xf8, 0x1f, 0x80, 0xf0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 3, 8, 1, 14, 0}
#define NXFONT_BITMAP_39 {0xe0, 0xe0, 0xe0, 0xe0, 0x40, 0x40, 0x40, 0x40}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 8, 28, 2, 14, 0}
#define NXFONT_BITMAP_40 {0x3, 0x6, 0xc, 0x18, 0x38, 0x30, 0x70, 0x70, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x70, 0x70, 0x30, 0x38, 0x18, 0xc, 0x6, 0x3}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 8, 28, 1, 14, 0}
#define NXFONT_BITMAP_41 {0xc0, 0x60, 0x30, 0x18, 0x1c, 0xc, 0xe, 0xe, 0x6, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x6, 0xe, 0xe, 0xc, 0x1c, 0x18, 0x30, 0x60, 0xc0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 12, 13, 2, 14, 0}
#define NXFONT_BITMAP_42 {0x6, 0x0, 0xf, 0x0, 0x6, 0x0, 0xc6, 0x30, 0xf6, 0xf0, 0x76, 0xe0, 0xf, 0x0, 0x76, 0xe0, 0xf6, 0xf0, 0xc6, 0x30, 0x6, 0x0, 0xf, 0x0, 0x6, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 16, 16, 1, 20, 0}
#define NXFONT_BITMAP_43 {0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0xff, 0xff, 0xff, 0xff, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 4, 7, 2, 33, 0}
#define NXFONT_BITMAP_44 {0x60, 0xf0, 0xf0, 0x70, 0x10, 0x20, 0x40}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 8, 2, 1, 28, 0}
#define NXFONT_BITMAP_45 {0xff, 0xff}

/* period (46) */
#define NXFONT_METRICS_46 {1, 4, 4, 2, 33, 0}
#define NXFONT_BITMAP_46 {0x60, 0xf0, 0xf0, 0x60}

/* slash (47) */
#define NXFONT_METRICS_47 {2, 10, 26, 0, 14, 0}
#define NXFONT_BITMAP_47 {0x0, 0xc0, 0x0, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x3, 0x80, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xe, 0x0, 0xc, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x18, 0x0, 0x18, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x70, 0x0, 0x60, 0x0, 0x60, 0x0, 0xc0, 0x0, 0xc0, 0x0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_48 {0x7, 0x80, 0x1c, 0xe0, 0x38, 0x70, 0x30, 0x30, 0x70, 0x38, 0x70, 0x38, 0x60, 0x18, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x18, 0x70, 0x38, 0x70, 0x38, 0x30, 0x30, 0x38, 0x70, 0x1c, 0xe0, 0x7, 0x80}

/* one (49) */
#define NXFONT_METRICS_49 {2, 9, 23, 4, 14, 0}
#define NXFONT_BITMAP_49 {0xc, 0x0, 0x1c, 0x0, 0x7c, 0x0, 0xdc, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* two (50) */
#define NXFONT_METRICS_50 {2, 15, 23, 0, 14, 0}
#define NXFONT_BITMAP_50 {0x7, 0xe0, 0xf, 0xf0, 0x1c, 0xf8, 0x30, 0x3c, 0x20, 0x3c, 0x60, 0x1c, 0x40, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x38, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x6, 0x0, 0xc, 0x2, 0x18, 0x6, 0x3f, 0xfc, 0x7f, 0xf8, 0xff, 0xf8}

/* three (51) */
#define NXFONT_METRICS_51 {2, 12, 23, 2, 14, 0}
#define NXFONT_BITMAP_51 {0xf, 0x80, 0x3f, 0xc0, 0x61, 0xe0, 0xc0, 0xe0, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xc0, 0x0, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x7, 0xc0, 0x1f, 0xe0, 0x1, 0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x70, 0x0, 0x60, 0xe0, 0xc0, 0xf3, 0x80, 0x7f, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_52 {0x0, 0x60, 0x0, 0xe0, 0x0, 0xe0, 0x1, 0xe0, 0x1, 0x60, 0x3, 0x60, 0x6, 0x60, 0x4, 0x60, 0xc, 0x60, 0x18, 0x60, 0x10, 0x60, 0x30, 0x60, 0x60, 0x60, 0x40, 0x60, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60}

/* five (53) */
#define NXFONT_METRICS_53 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_53 {0xf, 0xf8, 0x1f, 0xf0, 0x1f, 0xe0, 0x10, 0x0, 0x30, 0x0, 0x20, 0x0, 0x7e, 0x0, 0x7f, 0x80, 0x7f, 0xc0, 0x7, 0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0xe0, 0xc0, 0xf3, 0x80, 0x7e, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_54 {0x0, 0x78, 0x1, 0xc0, 0x3, 0x80, 0xf, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x78, 0x0, 0x70, 0x0, 0x73, 0xc0, 0xf7, 0xf0, 0xf8, 0x78, 0xe0, 0x38, 0xe0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x1c, 0x70, 0x18, 0x38, 0x38, 0x1c, 0x60, 0x7, 0xc0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_55 {0x3f, 0xfc, 0x7f, 0xfc, 0x60, 0x18, 0xc0, 0x18, 0x80, 0x38, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0xe0, 0x0, 0xc0, 0x0, 0xc0, 0x1, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x7, 0x0, 0x6, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 13, 23, 2, 14, 0}
#define NXFONT_BITMAP_56 {0x1f, 0x80, 0x38, 0xe0, 0x70, 0x70, 0xe0, 0x30, 0xe0, 0x30, 0xe0, 0x30, 0xe0, 0x70, 0xf0, 0x60, 0x7c, 0xc0, 0x3f, 0x0, 0x1f, 0x80, 0xf, 0xc0, 0x1b, 0xe0, 0x71, 0xf0, 0x60, 0xf0, 0xe0, 0x78, 0xc0, 0x78, 0xc0, 0x38, 0xc0, 0x38, 0xe0, 0x38, 0x60, 0x70, 0x70, 0xe0, 0x1f, 0xc0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_57 {0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xf0, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3e, 0xfc, 0xf, 0xb8, 0x0, 0x38, 0x0, 0x70, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0xf, 0x0, 0x78, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 4, 15, 2, 22, 0}
#define NXFONT_BITMAP_58 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x60}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 4, 18, 2, 22, 0}
#define NXFONT_BITMAP_59 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x70, 0x10, 0x20, 0x40}

/* less (60) */
#define NXFONT_METRICS_60 {2, 16, 18, 1, 19, 0}
#define NXFONT_BITMAP_60 {0x0, 0x1, 0x0, 0x7, 0x0, 0x1f, 0x0, 0x7c, 0x1, 0xf0, 0x7, 0xc0, 0x1f, 0x0, 0x7c, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xf0, 0x0, 0x7c, 0x0, 0x1f, 0x0, 0x7, 0x0, 0x1}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 16, 9, 1, 24, 0}
#define NXFONT_BITMAP_61 {0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 16, 18, 2, 19, 0}
#define NXFONT_BITMAP_62 {0x80, 0x0, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x0, 0xf, 0x0, 0x3e, 0x0, 0xf8, 0x3, 0xe0, 0xf, 0x80, 0x3e, 0x0, 0xf8, 0x0, 0xe0, 0x0, 0x80, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 11, 23, 2, 14, 0}
#define NXFONT_BITMAP_63 {0x1f, 0x0, 0x73, 0x80, 0xc1, 0xc0, 0xc1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0xe0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0x80, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0xc, 0x0}

/* at (64) */
#define NXFONT_METRICS_64 {4, 27, 28, 2, 14, 0}
#define NXFONT_BITMAP_64 {0x0, 0x1f, 0xf0, 0x0, 0x0, 0xf8, 0x3c, 0x0, 0x1, 0xe0, 0x6, 0x0, 0x7, 0x80, 0x3, 0x0, 0xe, 0x0, 0x1, 0x80, 0x1c, 0x0, 0x0, 0xc0, 0x1c, 0x0, 0x0, 0xc0, 0x38, 0x7, 0x8c, 0x60, 0x70, 0x1f, 0x5c, 0x60, 0x70, 0x1c, 0x7c, 0x20, 0x70, 0x38, 0x38, 0x20, 0xe0, 0x70, 0x38, 0x20, 0xe0, 0x70, 0x30, 0x20, 0xe0, 0x70, 0x70, 0x20, 0xe0, 0xe0, 0x70, 0x60, 0xe0, 0xe0, 0x70, 0x40, 0xe0, 0xe0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe0, 0x80, 0x70, 0xe1, 0xe1, 0x80, 0x70, 0x77, 0x73, 0x0, 0x70, 0x3c, 0x3e, 0x0, 0x38, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x7, 0x80, 0x6, 0x0, 0x1, 0xf0, 0x3c, 0x0, 0x0, 0x7f, 0xf0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_65 {0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* B (66) */
#define NXFONT_METRICS_66 {3, 20, 23, 1, 14, 0}
#define NXFONT_BITMAP_66 {0xff, 0xfe, 0x0, 0x3e, 0xf, 0x80, 0x1c, 0x3, 0xc0, 0x1c, 0x1, 0xc0, 0x1c, 0x1, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x1, 0xe0, 0x1c, 0x1, 0xc0, 0x1c, 0x3, 0xc0, 0x1c, 0xf, 0x80, 0x1f, 0xfe, 0x0, 0x1c, 0x7, 0x80, 0x1c, 0x1, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xf0, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0xf0, 0x1c, 0x0, 0xe0, 0x1c, 0x1, 0xe0, 0x3e, 0x7, 0xc0, 0xff, 0xff, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {3, 20, 23, 1, 14, 0}
#define NXFONT_BITMAP_67 {0x1, 0xff, 0x10, 0x7, 0x83, 0xf0, 0xe, 0x0, 0xf0, 0x1c, 0x0, 0x70, 0x38, 0x0, 0x30, 0x38, 0x0, 0x30, 0x70, 0x0, 0x10, 0x70, 0x0, 0x10, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x10, 0x1c, 0x0, 0x30, 0xe, 0x0, 0x60, 0x7, 0x83, 0xc0, 0x1, 0xff, 0x0}

/* D (68) */
#define NXFONT_METRICS_68 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_68 {0xff, 0xfe, 0x0, 0x3e, 0x7, 0x80, 0x1c, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0x1c, 0x1, 0xc0, 0x3e, 0x7, 0x80, 0xff, 0xfe, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_69 {0xff, 0xff, 0xc0, 0x3e, 0x3, 0xc0, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x3, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0x3, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* F (70) */
#define NXFONT_METRICS_70 {3, 17, 23, 1, 14, 0}
#define NXFONT_BITMAP_70 {0xff, 0xff, 0x80, 0x3e, 0x7, 0x80, 0x1c, 0x1, 0x80, 0x1c, 0x0, 0x80, 0x1c, 0x0, 0x80, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x2, 0x0, 0x1c, 0x2, 0x0, 0x1c, 0x6, 0x0, 0x1f, 0xfe, 0x0, 0x1c, 0x6, 0x0, 0x1c, 0x2, 0x0, 0x1c, 0x2, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xff, 0x80, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_71 {0x1, 0xff, 0x30, 0x7, 0x87, 0xf0, 0xe, 0x0, 0xf0, 0x1c, 0x0, 0x70, 0x38, 0x0, 0x30, 0x38, 0x0, 0x30, 0x70, 0x0, 0x10, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x3, 0xfc, 0xf0, 0x0, 0xf8, 0xf0, 0x0, 0x70, 0xf0, 0x0, 0x70, 0x70, 0x0, 0x70, 0x70, 0x0, 0x70, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0x70, 0xe, 0x0, 0x70, 0x7, 0x81, 0xe0, 0x1, 0xff, 0x80}

/* H (72) */
#define NXFONT_METRICS_72 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_72 {0xff, 0x87, 0xfc, 0x3e, 0x1, 0xf0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1f, 0xff, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x3e, 0x1, 0xf0, 0xff, 0x87, 0xfc}

/* I (73) */
#define NXFONT_METRICS_73 {2, 9, 23, 1, 14, 0}
#define NXFONT_BITMAP_73 {0xff, 0x80, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* J (74) */
#define NXFONT_METRICS_74 {2, 12, 23, 1, 14, 0}
#define NXFONT_BITMAP_74 {0x1f, 0xf0, 0x7, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0xc3, 0x80, 0xe3, 0x0, 0xe7, 0x0, 0x7c, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {3, 23, 23, 1, 14, 0}
#define NXFONT_BITMAP_75 {0xff, 0xc7, 0xf8, 0x3e, 0x1, 0xe0, 0x1c, 0x1, 0x80, 0x1c, 0x3, 0x0, 0x1c, 0x6, 0x0, 0x1c, 0xc, 0x0, 0x1c, 0x18, 0x0, 0x1c, 0x30, 0x0, 0x1c, 0x60, 0x0, 0x1c, 0xc0, 0x0, 0x1f, 0xc0, 0x0, 0x1f, 0xe0, 0x0, 0x1f, 0xf0, 0x0, 0x1e, 0x78, 0x0, 0x1c, 0x3c, 0x0, 0x1c, 0x1e, 0x0, 0x1c, 0xf, 0x0, 0x1c, 0x7, 0x80, 0x1c, 0x3, 0xc0, 0x1c, 0x1, 0xe0, 0x1c, 0x0, 0xf0, 0x3e, 0x0, 0xf8, 0xff, 0xc7, 0xfe}

/* L (76) */
#define NXFONT_METRICS_76 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_76 {0xff, 0x80, 0x0, 0x3e, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* M (77) */
#define NXFONT_METRICS_77 {4, 28, 23, 1, 14, 0}
#define NXFONT_BITMAP_77 {0xfc, 0x0, 0x7, 0xf0, 0x3e, 0x0, 0x7, 0xc0, 0x1e, 0x0, 0xf, 0x80, 0x1f, 0x0, 0xf, 0x80, 0x1f, 0x0, 0xb, 0x80, 0x17, 0x0, 0x1b, 0x80, 0x17, 0x80, 0x1b, 0x80, 0x13, 0x80, 0x33, 0x80, 0x13, 0xc0, 0x33, 0x80, 0x13, 0xc0, 0x23, 0x80, 0x11, 0xe0, 0x63, 0x80, 0x11, 0xe0, 0x63, 0x80, 0x10, 0xe0, 0xc3, 0x80, 0x10, 0xf0, 0xc3, 0x80, 0x10, 0x70, 0x83, 0x80, 0x10, 0x79, 0x83, 0x80, 0x10, 0x79, 0x3, 0x80, 0x10, 0x3d, 0x3, 0x80, 0x10, 0x3f, 0x3, 0x80, 0x10, 0x1e, 0x3, 0x80, 0x10, 0x1e, 0x3, 0x80, 0x38, 0xc, 0x7, 0xc0, 0xfe, 0xc, 0x1f, 0xf0}

/* N (78) */
#define NXFONT_METRICS_78 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_78 {0xf8, 0x1, 0xfc, 0x3c, 0x0, 0x70, 0x1e, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x17, 0x80, 0x20, 0x13, 0xc0, 0x20, 0x13, 0xc0, 0x20, 0x11, 0xe0, 0x20, 0x10, 0xf0, 0x20, 0x10, 0xf8, 0x20, 0x10, 0x78, 0x20, 0x10, 0x3c, 0x20, 0x10, 0x1e, 0x20, 0x10, 0x1f, 0x20, 0x10, 0xf, 0x20, 0x10, 0x7, 0xa0, 0x10, 0x3, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x0, 0xe0, 0x38, 0x0, 0x60, 0xfe, 0x0, 0x20}

/* O (79) */
#define NXFONT_METRICS_79 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_79 {0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {3, 17, 23, 1, 14, 0}
#define NXFONT_BITMAP_80 {0xff, 0xf8, 0x0, 0x3c, 0x3e, 0x0, 0x1c, 0xf, 0x0, 0x1c, 0x7, 0x0, 0x1c, 0x7, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x7, 0x80, 0x1c, 0x7, 0x0, 0x1c, 0xf, 0x0, 0x1c, 0x3e, 0x0, 0x1f, 0xf0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xff, 0x80, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 22, 29, 1, 14, 0}
#define NXFONT_BITMAP_81 {0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7c}

/* R (82) */
#define NXFONT_METRICS_82 {3, 21, 23, 1, 14, 0}
#define NXFONT_BITMAP_82 {0xff, 0xf8, 0x0, 0x3c, 0x3e, 0x0, 0x1c, 0xf, 0x0, 0x1c, 0x7, 0x80, 0x1c, 0x7, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x7, 0x80, 0x1c, 0x7, 0x0, 0x1c, 0x1e, 0x0, 0x1f, 0xf8, 0x0, 0x1c, 0xf0, 0x0, 0x1c, 0x78, 0x0, 0x1c, 0x3c, 0x0, 0x1c, 0x3c, 0x0, 0x1c, 0x1e, 0x0, 0x1c, 0xf, 0x0, 0x1c, 0xf, 0x80, 0x1c, 0x7, 0x80, 0x1c, 0x3, 0xc0, 0x3e, 0x1, 0xe0, 0xff, 0x81, 0xf8}

/* S (83) */
#define NXFONT_METRICS_83 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_83 {0x7, 0xe4, 0x1c, 0x3c, 0x38, 0x1c, 0x70, 0xc, 0x70, 0x4, 0x70, 0x6, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x0, 0x1f, 0x80, 0xf, 0xe0, 0x7, 0xf0, 0x1, 0xf8, 0x0, 0x7c, 0x0, 0x3e, 0x0, 0x1e, 0x80, 0xe, 0x80, 0xe, 0xc0, 0xe, 0xe0, 0xc, 0x70, 0x1c, 0x7c, 0x78, 0x67, 0xf0}

/* T (84) */
#define NXFONT_METRICS_84 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_84 {0xff, 0xff, 0xe0, 0xf0, 0xe1, 0xe0, 0xc0, 0xe0, 0x60, 0xc0, 0xe0, 0x60, 0x80, 0xe0, 0x20, 0x80, 0xe0, 0x20, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x7, 0xfc, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_85 {0xff, 0x81, 0xfc, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1e, 0x0, 0x60, 0xe, 0x0, 0x40, 0xf, 0x0, 0xc0, 0x7, 0xc3, 0x80, 0x1, 0xfe, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_86 {0xff, 0x1, 0xfc, 0x7c, 0x0, 0x70, 0x3c, 0x0, 0x60, 0x1e, 0x0, 0x40, 0x1e, 0x0, 0xc0, 0xe, 0x0, 0xc0, 0xf, 0x0, 0x80, 0xf, 0x1, 0x80, 0x7, 0x1, 0x80, 0x7, 0x81, 0x0, 0x3, 0x83, 0x0, 0x3, 0xc3, 0x0, 0x3, 0xc2, 0x0, 0x1, 0xc6, 0x0, 0x1, 0xe6, 0x0, 0x0, 0xe4, 0x0, 0x0, 0xec, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0x38, 0x0, 0x0, 0x30, 0x0, 0x0, 0x10, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {4, 31, 23, 1, 14, 0}
#define NXFONT_BITMAP_87 {0xff, 0x3f, 0xe0, 0xfe, 0x7c, 0xf, 0x80, 0x78, 0x3c, 0x7, 0x0, 0x30, 0x1c, 0x7, 0x80, 0x30, 0x1e, 0x7, 0x80, 0x60, 0x1e, 0x3, 0x80, 0x60, 0xe, 0x3, 0xc0, 0x60, 0xf, 0x3, 0xc0, 0xc0, 0x7, 0x3, 0xe0, 0xc0, 0x7, 0x87, 0xe0, 0xc0, 0x7, 0x86, 0xe1, 0x80, 0x3, 0x84, 0xf1, 0x80, 0x3, 0xcc, 0xf1, 0x80, 0x3, 0xcc, 0x73, 0x0, 0x1, 0xd8, 0x7b, 0x0, 0x1, 0xd8, 0x3b, 0x0, 0x1, 0xf8, 0x3e, 0x0, 0x0, 0xf0, 0x3e, 0x0, 0x0, 0xf0, 0x1c, 0x0, 0x0, 0xe0, 0x1c, 0x0, 0x0, 0x60, 0x1c, 0x0, 0x0, 0x60, 0x8, 0x0, 0x0, 0x40, 0x8, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_88 {0xff, 0xc3, 0xfc, 0x3f, 0x0, 0xf0, 0x1f, 0x0, 0xe0, 0xf, 0x0, 0xc0, 0x7, 0x81, 0x80, 0x7, 0x83, 0x0, 0x3, 0xc6, 0x0, 0x1, 0xe6, 0x0, 0x1, 0xec, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xde, 0x0, 0x1, 0x9e, 0x0, 0x1, 0x8f, 0x0, 0x3, 0xf, 0x80, 0x6, 0x7, 0x80, 0xe, 0x3, 0xc0, 0xc, 0x3, 0xe0, 0x18, 0x1, 0xe0, 0x38, 0x1, 0xf0, 0xfe, 0x7, 0xfc}

/* Y (89) */
#define NXFONT_METRICS_89 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_89 {0xff, 0xc0, 0xfc, 0x3f, 0x0, 0x38, 0x1e, 0x0, 0x30, 0xf, 0x0, 0x60, 0xf, 0x80, 0xc0, 0x7, 0x80, 0x80, 0x3, 0xc1, 0x80, 0x3, 0xc3, 0x0, 0x1, 0xe3, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xff, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_90 {0x3f, 0xff, 0xe0, 0x38, 0x3, 0xc0, 0x60, 0x7, 0x80, 0x60, 0x7, 0x80, 0x40, 0xf, 0x0, 0x40, 0x1e, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x7, 0x80, 0x0, 0xf, 0x0, 0x0, 0xf, 0x0, 0x20, 0x1e, 0x0, 0x20, 0x3c, 0x0, 0x60, 0x3c, 0x0, 0x60, 0x78, 0x1, 0xc0, 0xff, 0xff, 0xc0}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 7, 28, 3, 14, 0}
#define NXFONT_BITMAP_91 {0xfe, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xfe}

/* backslash (92) -- NOTE: Xoffset should be -2, not 0. */
#define NXFONT_METRICS_92 {2, 13, 23, 0, 14, 0}
#define NXFONT_BITMAP_92 {0xc0, 0x0, 0xe0, 0x0, 0x60, 0x0, 0x70, 0x0, 0x30, 0x0, 0x38, 0x0, 0x18, 0x0, 0x1c, 0x0, 0xc, 0x0, 0xe, 0x0, 0x6, 0x0, 0x7, 0x0, 0x3, 0x0, 0x3, 0x80, 0x1, 0x80, 0x1, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x60, 0x0, 0x70, 0x0, 0x30, 0x0, 0x38, 0x0, 0x18}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 7, 28, 1, 14, 0}
#define NXFONT_BITMAP_93 {0xfe, 0x1e, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0x1e, 0xfe}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 13, 13, 1, 14, 0}
#define NXFONT_BITMAP_94 {0x7, 0x0, 0x7, 0x0, 0xf, 0x80, 0xd, 0x80, 0x18, 0xc0, 0x18, 0xc0, 0x30, 0x60, 0x30, 0x60, 0x70, 0x70, 0x60, 0x30, 0xe0, 0x38, 0xc0, 0x18, 0xc0, 0x18}

/* underscore (95) */
#define NXFONT_METRICS_95 {3, 17, 2, 0, 40, 0}
#define NXFONT_BITMAP_95 {0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 7, 6, 1, 14, 0}
#define NXFONT_BITMAP_96 {0xc0, 0xe0, 0x70, 0x18, 0xc, 0x6}

/* a (97) */
#define NXFONT_METRICS_97 {2, 13, 15, 1, 22, 0}
#define NXFONT_BITMAP_97 {0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* b (98) */
#define NXFONT_METRICS_98 {2, 15, 23, 0, 14, 0}
#define NXFONT_BITMAP_98 {0x18, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x39, 0xf0, 0x3b, 0xf8, 0x3c, 0x7c, 0x38, 0x1c, 0x38, 0x1e, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xc, 0x38, 0x1c, 0x38, 0x18, 0x3c, 0x70, 0xf, 0xe0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 12, 15, 1, 22, 0}
#define NXFONT_BITMAP_99 {0xf, 0x80, 0x38, 0xc0, 0x70, 0xe0, 0x60, 0xe0, 0xe0, 0x60, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0x1f, 0x0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_100 {0x0, 0x18, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0xf, 0xb8, 0x18, 0xf8, 0x30, 0x78, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x38, 0x70, 0x78, 0x78, 0xf8, 0x3f, 0xbe, 0xf, 0x30}

/* e (101) */
#define NXFONT_METRICS_101 {2, 12, 15, 1, 22, 0}
#define NXFONT_BITMAP_101 {0xf, 0x80, 0x39, 0xc0, 0x60, 0xe0, 0x60, 0x70, 0xc0, 0x70, 0xff, 0xf0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0}

/* f (102) */
#define NXFONT_METRICS_102 {2, 12, 23, 0, 14, 0}
#define NXFONT_BITMAP_102 {0x3, 0xe0, 0x6, 0x70, 0xc, 0x70, 0xc, 0x30, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xff, 0xc0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* g (103) */
#define NXFONT_METRICS_103 {2, 14, 22, 1, 22, 0}
#define NXFONT_BITMAP_103 {0xf, 0xc0, 0x18, 0xfc, 0x30, 0x7c, 0x70, 0x30, 0x70, 0x30, 0x70, 0x30, 0x70, 0x30, 0x38, 0x70, 0x1c, 0xe0, 0xf, 0x80, 0x18, 0x0, 0x30, 0x0, 0x78, 0x0, 0x7f, 0xe0, 0x3f, 0xf8, 0x1f, 0xfc, 0x60, 0xc, 0xc0, 0xc, 0xc0, 0x1c, 0xf0, 0x38, 0x7f, 0xe0, 0x1f, 0x80}

/* h (104) */
#define NXFONT_METRICS_104 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_104 {0x18, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x39, 0xf0, 0x3b, 0xf8, 0x3e, 0x3c, 0x3c, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0xfe, 0x7f}

/* i (105) */
#define NXFONT_METRICS_105 {1, 7, 23, 1, 14, 0}
#define NXFONT_BITMAP_105 {0x38, 0x38, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xfe}

/* j (106) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_106 {1, 8, 30, 0, 14, 0}
#define NXFONT_BITMAP_106 {0x7, 0x7, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x1f, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x6, 0xc6, 0xec, 0x78}

/* k (107) */
#define NXFONT_METRICS_107 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_107 {0x18, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0xfe, 0x38, 0x70, 0x38, 0x60, 0x38, 0xc0, 0x39, 0x80, 0x3f, 0x0, 0x3e, 0x0, 0x3f, 0x0, 0x3b, 0x80, 0x39, 0xc0, 0x38, 0xe0, 0x38, 0xf0, 0x38, 0x78, 0x38, 0x3c, 0xfe, 0x7f}

/* l (108) */
#define NXFONT_METRICS_108 {1, 7, 23, 1, 14, 0}
#define NXFONT_BITMAP_108 {0x18, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xfe}

/* m (109) */
#define NXFONT_METRICS_109 {4, 25, 15, 0, 22, 0}
#define NXFONT_BITMAP_109 {0x18, 0xf0, 0x78, 0x0, 0xfb, 0xf9, 0xfc, 0x0, 0x3e, 0x3f, 0x1e, 0x0, 0x3c, 0x1e, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0x38, 0x1c, 0xe, 0x0, 0xfe, 0x7f, 0x3f, 0x80}

/* n (110) */
#define NXFONT_METRICS_110 {2, 16, 15, 0, 22, 0}
#define NXFONT_BITMAP_110 {0x18, 0xf0, 0xfb, 0xf8, 0x3c, 0x3c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0xfe, 0x7f}

/* o (111) */
#define NXFONT_METRICS_111 {2, 14, 15, 1, 22, 0}
#define NXFONT_BITMAP_111 {0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* p (112) */
#define NXFONT_METRICS_112 {2, 15, 22, 0, 22, 0}
#define NXFONT_BITMAP_112 {0x19, 0xe0, 0xfb, 0xf8, 0x3c, 0x7c, 0x38, 0x1c, 0x38, 0x1e, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xc, 0x38, 0x1c, 0x3c, 0x18, 0x3e, 0x70, 0x3b, 0xc0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0xff, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 15, 22, 1, 22, 0}
#define NXFONT_BITMAP_113 {0xf, 0xc8, 0x1c, 0x78, 0x30, 0x38, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x38, 0x70, 0x78, 0x78, 0xf8, 0x3f, 0xb8, 0x1f, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x1, 0xfe}

/* r (114) */
#define NXFONT_METRICS_114 {2, 10, 15, 1, 22, 0}
#define NXFONT_BITMAP_114 {0x19, 0x80, 0xfb, 0xc0, 0x3f, 0xc0, 0x3c, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0xfe, 0x0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 10, 15, 1, 22, 0}
#define NXFONT_BITMAP_115 {0x3e, 0x80, 0x63, 0x80, 0xc1, 0x80, 0xc0, 0x80, 0xe0, 0x80, 0xf0, 0x0, 0x7c, 0x0, 0x3f, 0x0, 0xf, 0x80, 0x3, 0xc0, 0x81, 0xc0, 0x80, 0xc0, 0xc0, 0xc0, 0xe1, 0x80, 0xbf, 0x0}

/* t (116) */
#define NXFONT_METRICS_116 {2, 9, 19, 0, 18, 0}
#define NXFONT_BITMAP_116 {0x8, 0x0, 0x8, 0x0, 0x18, 0x0, 0x38, 0x0, 0xff, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x80, 0x3f, 0x0, 0x1c, 0x0}

/* u (117) */
#define NXFONT_METRICS_117 {2, 16, 15, 0, 22, 0}
#define NXFONT_BITMAP_117 {0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x5c, 0x1f, 0xdf, 0xf, 0x8c}

/* v (118) */
#define NXFONT_METRICS_118 {2, 15, 15, 1, 22, 0}
#define NXFONT_BITMAP_118 {0xfe, 0x3e, 0x78, 0xc, 0x38, 0x8, 0x3c, 0x18, 0x1c, 0x18, 0x1c, 0x10, 0xe, 0x30, 0xe, 0x20, 0x7, 0x60, 0x7, 0x40, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0x80, 0x1, 0x80, 0x1, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {3, 21, 15, 1, 22, 0}
#define NXFONT_BITMAP_119 {0xfd, 0xfc, 0x78, 0x70, 0x70, 0x30, 0x70, 0x70, 0x30, 0x38, 0x30, 0x20, 0x38, 0x38, 0x60, 0x18, 0x38, 0x40, 0x1c, 0x78, 0x40, 0x1c, 0x5c, 0xc0, 0xc, 0xcc, 0x80, 0xe, 0x8f, 0x80, 0xf, 0x8f, 0x0, 0x7, 0x7, 0x0, 0x7, 0x7, 0x0, 0x3, 0x6, 0x0, 0x2, 0x2, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 14, 15, 1, 22, 0}
#define NXFONT_BITMAP_120 {0xfc, 0xf8, 0x38, 0x60, 0x3c, 0xc0, 0x1c, 0x80, 0x1e, 0x80, 0xf, 0x0, 0x7, 0x0, 0x7, 0x80, 0xf, 0x80, 0xb, 0xc0, 0x19, 0xe0, 0x10, 0xe0, 0x30, 0x70, 0x60, 0x78, 0xf0, 0xfc}

/* y (121) */
#define NXFONT_METRICS_121 {2, 15, 22, 1, 22, 0}
#define NXFONT_BITMAP_121 {0xfe, 0x1e, 0x78, 0xc, 0x38, 0xc, 0x3c, 0x8, 0x1c, 0x18, 0x1e, 0x18, 0xe, 0x10, 0xe, 0x30, 0x7, 0x20, 0x7, 0x20, 0x3, 0xe0, 0x3, 0xc0, 0x1, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 0x2, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0x38, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 13, 15, 1, 22, 0}
#define NXFONT_BITMAP_122 {0x7f, 0xf0, 0x60, 0xf0, 0x40, 0xe0, 0x41, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x1c, 0x8, 0x38, 0x8, 0x78, 0x8, 0x70, 0x18, 0xff, 0xf0}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 8, 28, 4, 14, 0}
#define NXFONT_BITMAP_123 {0xf, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x30, 0xe0, 0x30, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x1c, 0xf}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 23, 2, 14, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 8, 28, 4, 14, 0}
#define NXFONT_BITMAP_125 {0xf0, 0x38, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xc, 0x7, 0xc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x38, 0xf0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 16, 4, 1, 26, 0}
#define NXFONT_BITMAP_126 {0x3e, 0x3, 0x7f, 0x87, 0xe1, 0xfe, 0xc0, 0x7c}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 4, 22, 3, 22, 0}
#define NXFONT_BITMAP_161 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0xf0, 0xf0, 0xf0, 0x60}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 12, 23, 2, 18, 0}
#define NXFONT_BITMAP_162 {0x0, 0x40, 0x0, 0x40, 0x0, 0x80, 0x0, 0x80, 0xf, 0x80, 0x38, 0xe0, 0x71, 0x70, 0x61, 0x70, 0xe1, 0x30, 0xc3, 0x0, 0xc2, 0x0, 0xc2, 0x0, 0xe6, 0x0, 0xe4, 0x0, 0x74, 0x10, 0x7c, 0x30, 0x3f, 0xe0, 0x1f, 0xc0, 0x1f, 0x0, 0x10, 0x0, 0x30, 0x0, 0x20, 0x0, 0x20, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_163 {0x1, 0xf0, 0x3, 0x98, 0x6, 0x1c, 0x6, 0x1c, 0xe, 0x18, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xf, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x6, 0x0, 0x6, 0x2, 0x7e, 0x6, 0xc7, 0xfc, 0xcf, 0xf8, 0x78, 0xf0}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 16, 17, 0, 17, 0}
#define NXFONT_BITMAP_164 {0xc7, 0xe3, 0xff, 0xff, 0x3e, 0x7c, 0x78, 0x1e, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xe0, 0x7, 0xe0, 0x7, 0x70, 0xe, 0x78, 0x1e, 0x3e, 0x7c, 0xff, 0xff, 0xc7, 0xe3}

/* yen (165) */
#define NXFONT_METRICS_165 {3, 17, 23, 0, 14, 0}
#define NXFONT_BITMAP_165 {0xfe, 0x1f, 0x80, 0x78, 0x7, 0x0, 0x38, 0x6, 0x0, 0x3c, 0x4, 0x0, 0x1c, 0xc, 0x0, 0x1e, 0x8, 0x0, 0xe, 0x18, 0x0, 0xf, 0x10, 0x0, 0x7, 0x30, 0x0, 0x7, 0xa0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xc0, 0x0, 0x3f, 0xfe, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x3f, 0xfe, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x7, 0xf0, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 23, 2, 14, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 12, 28, 2, 14, 0}
#define NXFONT_BITMAP_167 {0x1f, 0x80, 0x31, 0xc0, 0x61, 0xc0, 0x61, 0xc0, 0x71, 0x80, 0x38, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x3f, 0x80, 0x63, 0xc0, 0xc1, 0xe0, 0xc0, 0xe0, 0xc0, 0x70, 0xe0, 0x30, 0x70, 0x30, 0x78, 0x30, 0x3c, 0x60, 0x1f, 0xc0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xc0, 0x18, 0xe0, 0x38, 0x60, 0x38, 0x60, 0x38, 0xc0, 0x1f, 0x80}

/* dieresis (168) */
#define NXFONT_METRICS_168 {2, 9, 3, 1, 16, 0}
#define NXFONT_BITMAP_168 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_169 {0x0, 0xfc, 0x0, 0x3, 0xff, 0x0, 0xe, 0x1, 0xc0, 0x18, 0x0, 0x60, 0x30, 0x0, 0x30, 0x60, 0x0, 0x18, 0x60, 0x7f, 0x18, 0xc1, 0xc7, 0xc, 0xc3, 0x83, 0xc, 0xc3, 0x1, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x80, 0xc, 0x43, 0x81, 0x18, 0x61, 0xe6, 0x18, 0x60, 0x7c, 0x30, 0x30, 0x0, 0x30, 0x18, 0x0, 0x60, 0xe, 0x1, 0xc0, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {2, 9, 13, 0, 14, 0}
#define NXFONT_BITMAP_170 {0x3c, 0x0, 0x4e, 0x0, 0xc6, 0x0, 0xc6, 0x0, 0x1e, 0x0, 0x66, 0x0, 0xc6, 0x0, 0xc6, 0x0, 0xef, 0x80, 0x7b, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 13, 13, 1, 23, 0}
#define NXFONT_BITMAP_171 {0x2, 0x8, 0x6, 0x18, 0xc, 0x30, 0x18, 0x60, 0x38, 0xe0, 0x71, 0xc0, 0xe3, 0x80, 0x71, 0xc0, 0x38, 0xe0, 0x18, 0x60, 0xc, 0x30, 0x6, 0x18, 0x2, 0x8}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 16, 9, 1, 24, 0}
#define NXFONT_BITMAP_172 {0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 8, 2, 1, 28, 0}
#define NXFONT_BITMAP_173 {0xff, 0xff}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_174 {0x0, 0xfe, 0x0, 0x3, 0xff, 0x0, 0xe, 0x1, 0xc0, 0x18, 0x0, 0x60, 0x30, 0x0, 0x30, 0x23, 0xfc, 0x18, 0x60, 0xc7, 0x18, 0xc0, 0xc3, 0xc, 0xc0, 0xc3, 0xc, 0xc0, 0xc3, 0xc, 0xc0, 0xc6, 0xc, 0xc0, 0xf8, 0xc, 0xc0, 0xdc, 0xc, 0xc0, 0xcc, 0xc, 0xc0, 0xce, 0xc, 0x40, 0xc6, 0x8, 0x60, 0xc7, 0x18, 0x23, 0xe3, 0xd0, 0x30, 0x0, 0x30, 0x18, 0x0, 0x60, 0xe, 0x1, 0xc0, 0x3, 0xff, 0x0, 0x0, 0xfc, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {2, 10, 2, 0, 17, 0}
#define NXFONT_BITMAP_175 {0xff, 0xc0, 0xff, 0xc0}

/* degree (176) */
#define NXFONT_METRICS_176 {2, 10, 10, 1, 14, 0}
#define NXFONT_BITMAP_176 {0x1e, 0x0, 0x3f, 0x0, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x3f, 0x0, 0x1e, 0x0}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 16, 20, 1, 17, 0}
#define NXFONT_BITMAP_177 {0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0xff, 0xff, 0xff, 0xff, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {2, 9, 14, 0, 14, 0}
#define NXFONT_BITMAP_178 {0x3c, 0x0, 0x4e, 0x0, 0x87, 0x0, 0x3, 0x0, 0x3, 0x0, 0x7, 0x0, 0x6, 0x0, 0xc, 0x0, 0x18, 0x0, 0x10, 0x0, 0x20, 0x0, 0x40, 0x80, 0xff, 0x0, 0xfe, 0x0}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {2, 9, 14, 0, 14, 0}
#define NXFONT_BITMAP_179 {0x3e, 0x0, 0x47, 0x0, 0x83, 0x0, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0, 0x3c, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0x80, 0x1, 0x80, 0xc1, 0x80, 0xe3, 0x0, 0x7e, 0x0}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 7, 6, 3, 14, 0}
#define NXFONT_BITMAP_180 {0x6, 0xe, 0x1c, 0x30, 0x60, 0xc0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 16, 22, 0, 22, 0}
#define NXFONT_BITMAP_181 {0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x7c, 0x3f, 0xdf, 0x2f, 0x98, 0x20, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x20, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 13, 29, 1, 14, 0}
#define NXFONT_BITMAP_182 {0x7, 0xf8, 0x1e, 0x20, 0x3e, 0x20, 0x7e, 0x20, 0x7e, 0x20, 0xfe, 0x20, 0xfe, 0x20, 0xfe, 0x20, 0xfe, 0x20, 0x7e, 0x20, 0x7e, 0x20, 0x3e, 0x20, 0x1e, 0x20, 0xe, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20, 0x2, 0x20}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 4, 4, 2, 26, 0}
#define NXFONT_BITMAP_183 {0x60, 0xf0, 0xf0, 0x60}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 6, 7, 2, 37, 0}
#define NXFONT_BITMAP_184 {0x20, 0x60, 0x78, 0x1c, 0xc, 0x1c, 0xf8}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 6, 14, 2, 14, 0}
#define NXFONT_BITMAP_185 {0x30, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {2, 9, 13, 0, 14, 0}
#define NXFONT_BITMAP_186 {0x3e, 0x0, 0x63, 0x0, 0xc3, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xe1, 0x80, 0x63, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 13, 13, 2, 23, 0}
#define NXFONT_BITMAP_187 {0x82, 0x0, 0xc3, 0x0, 0x61, 0x80, 0x30, 0xc0, 0x38, 0xe0, 0x1c, 0x70, 0xe, 0x38, 0x1c, 0x70, 0x38, 0xe0, 0x30, 0xc0, 0x61, 0x80, 0xc3, 0x0, 0x82, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {3, 22, 23, 2, 14, 0}
#define NXFONT_BITMAP_188 {0x30, 0x0, 0x60, 0xf0, 0x0, 0x60, 0x30, 0x0, 0xc0, 0x30, 0x1, 0xc0, 0x30, 0x1, 0x80, 0x30, 0x3, 0x0, 0x30, 0x3, 0x0, 0x30, 0x6, 0x0, 0x30, 0xe, 0x0, 0x30, 0xc, 0x10, 0x30, 0x18, 0x30, 0x30, 0x18, 0x70, 0x30, 0x30, 0x70, 0xfc, 0x60, 0xf0, 0x0, 0x61, 0xb0, 0x0, 0xc1, 0x30, 0x1, 0xc2, 0x30, 0x1, 0x86, 0x30, 0x3, 0xc, 0x30, 0x3, 0x1f, 0xfc, 0x6, 0x0, 0x30, 0xc, 0x0, 0x30, 0xc, 0x0, 0x30}

/* onehalf (189) */
#define NXFONT_METRICS_189 {3, 23, 23, 1, 14, 0}
#define NXFONT_BITMAP_189 {0x30, 0x0, 0xc0, 0xf0, 0x0, 0xc0, 0x30, 0x1, 0x80, 0x30, 0x3, 0x80, 0x30, 0x3, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0xc, 0x0, 0x30, 0x1c, 0x0, 0x30, 0x18, 0xf0, 0x30, 0x31, 0x38, 0x30, 0x32, 0x1c, 0x30, 0x60, 0xc, 0xfc, 0xe0, 0xc, 0x0, 0xc0, 0x1c, 0x1, 0x80, 0x18, 0x3, 0x80, 0x30, 0x3, 0x0, 0x60, 0x6, 0x0, 0x40, 0x6, 0x0, 0x80, 0xc, 0x1, 0x2, 0x18, 0x3, 0xfc, 0x18, 0x3, 0xf8}

/* threequarters (190) */
#define NXFONT_METRICS_190 {3, 24, 23, 0, 14, 0}
#define NXFONT_BITMAP_190 {0x3e, 0x0, 0x18, 0x47, 0x0, 0x18, 0x83, 0x0, 0x30, 0x3, 0x0, 0x70, 0x3, 0x0, 0x60, 0x6, 0x0, 0xc0, 0x3c, 0x0, 0xc0, 0x7, 0x1, 0x80, 0x3, 0x83, 0x80, 0x1, 0x83, 0x4, 0x1, 0x86, 0xc, 0xc1, 0x86, 0x1c, 0xe3, 0xc, 0x1c, 0x7e, 0x18, 0x3c, 0x0, 0x18, 0x6c, 0x0, 0x30, 0x4c, 0x0, 0x70, 0x8c, 0x0, 0x61, 0x8c, 0x0, 0xc3, 0xc, 0x0, 0xc7, 0xff, 0x1, 0x80, 0xc, 0x3, 0x0, 0xc, 0x3, 0x0, 0xc}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 11, 22, 1, 22, 0}
#define NXFONT_BITMAP_191 {0x6, 0x0, 0xf, 0x0, 0xf, 0x0, 0x6, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0x18, 0x0, 0x38, 0x0, 0x30, 0x0, 0x70, 0x0, 0x70, 0x0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0x70, 0x60, 0x70, 0x60, 0x39, 0xc0, 0x1f, 0x0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_192 {0x6, 0x0, 0x0, 0x7, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_193 {0x0, 0x1, 0x80, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xc, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_194 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xce, 0x0, 0x3, 0x3, 0x0, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 22, 28, 1, 9, 0}
#define NXFONT_BITMAP_195 {0x0, 0xe0, 0x80, 0x1, 0xf9, 0x80, 0x3, 0x3f, 0x0, 0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 22, 28, 1, 9, 0}
#define NXFONT_BITMAP_196 {0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_197 {0x0, 0x70, 0x0, 0x0, 0xf8, 0x0, 0x1, 0x8c, 0x0, 0x1, 0x4, 0x0, 0x1, 0x8c, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x9c, 0x0, 0x1, 0x8e, 0x0, 0x1, 0xe, 0x0, 0x3, 0xf, 0x0, 0x3, 0x7, 0x0, 0x2, 0x7, 0x0, 0x6, 0x7, 0x80, 0x6, 0x3, 0x80, 0xf, 0xff, 0xc0, 0xc, 0x3, 0xc0, 0x18, 0x1, 0xc0, 0x18, 0x1, 0xe0, 0x30, 0x1, 0xe0, 0x30, 0x0, 0xf0, 0x70, 0x0, 0xf0, 0xfc, 0x3, 0xfc}

/* AE (198) */
#define NXFONT_METRICS_198 {4, 28, 23, 1, 14, 0}
#define NXFONT_BITMAP_198 {0x0, 0xff, 0xff, 0xe0, 0x0, 0x1f, 0x81, 0xe0, 0x0, 0x1f, 0x0, 0x60, 0x0, 0x37, 0x0, 0x20, 0x0, 0x37, 0x0, 0x20, 0x0, 0x67, 0x0, 0x0, 0x0, 0x67, 0x0, 0x0, 0x0, 0x47, 0x0, 0x80, 0x0, 0xc7, 0x0, 0x80, 0x0, 0xc7, 0x1, 0x80, 0x1, 0x87, 0x3, 0x80, 0x1, 0x87, 0xff, 0x80, 0x3, 0x7, 0x3, 0x80, 0x3, 0x7, 0x1, 0x80, 0x7, 0xff, 0x0, 0x80, 0x6, 0x7, 0x0, 0x80, 0xc, 0x7, 0x0, 0x0, 0xc, 0x7, 0x0, 0x10, 0x18, 0x7, 0x0, 0x10, 0x18, 0x7, 0x0, 0x30, 0x30, 0x7, 0x0, 0x60, 0x30, 0xf, 0x81, 0xe0, 0xfe, 0x3f, 0xff, 0xe0}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {3, 20, 30, 1, 14, 0}
#define NXFONT_BITMAP_199 {0x1, 0xff, 0x10, 0x7, 0x83, 0xf0, 0xe, 0x0, 0xf0, 0x1c, 0x0, 0x70, 0x38, 0x0, 0x30, 0x38, 0x0, 0x30, 0x70, 0x0, 0x10, 0x70, 0x0, 0x10, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x10, 0x1c, 0x0, 0x30, 0xe, 0x0, 0x60, 0x7, 0x83, 0xc0, 0x1, 0xff, 0x0, 0x0, 0x40, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x18, 0x0, 0x0, 0x38, 0x0, 0x1, 0xf0, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {3, 19, 30, 1, 7, 0}
#define NXFONT_BITMAP_200 {0x3, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x30, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xc0, 0x3e, 0x3, 0xc0, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x3, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0x3, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* Eacute (201) */
#define NXFONT_METRICS_201 {3, 19, 30, 1, 7, 0}
#define NXFONT_BITMAP_201 {0x0, 0x6, 0x0, 0x0, 0xe, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x30, 0x0, 0x0, 0x60, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xc0, 0x3e, 0x3, 0xc0, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x3, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0x3, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {3, 19, 30, 1, 7, 0}
#define NXFONT_BITMAP_202 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xce, 0x0, 0x3, 0x3, 0x0, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xc0, 0x3e, 0x3, 0xc0, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x3, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0x3, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {3, 19, 28, 1, 9, 0}
#define NXFONT_BITMAP_203 {0x3, 0x8e, 0x0, 0x3, 0x8e, 0x0, 0x3, 0x8e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xc0, 0x3e, 0x3, 0xc0, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x3, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0x3, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x1, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x3e, 0x3, 0xc0, 0xff, 0xff, 0xc0}

/* Igrave (204) */
#define NXFONT_METRICS_204 {2, 9, 30, 1, 7, 0}
#define NXFONT_BITMAP_204 {0x60, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x6, 0x0, 0x3, 0x0, 0x0, 0x0, 0xff, 0x80, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* Iacute (205) */
#define NXFONT_METRICS_205 {2, 9, 30, 1, 7, 0}
#define NXFONT_BITMAP_205 {0x1, 0x80, 0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x18, 0x0, 0x30, 0x0, 0x0, 0x0, 0xff, 0x80, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {2, 10, 30, 1, 7, 0}
#define NXFONT_BITMAP_206 {0xc, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xc0, 0xc0, 0x80, 0x40, 0x0, 0x0, 0xff, 0x80, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {2, 9, 28, 1, 9, 0}
#define NXFONT_BITMAP_207 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* Eth (208) */
#define NXFONT_METRICS_208 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_208 {0xff, 0xfe, 0x0, 0x3e, 0x7, 0x80, 0x1c, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0xff, 0xc0, 0x3c, 0xff, 0xc0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0x1c, 0x1, 0xc0, 0x3e, 0x7, 0x80, 0xff, 0xfe, 0x0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {3, 22, 29, 1, 8, 0}
#define NXFONT_BITMAP_209 {0x0, 0xe0, 0x80, 0x1, 0xf9, 0x80, 0x3, 0x3f, 0x0, 0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x1, 0xfc, 0x3c, 0x0, 0x70, 0x1e, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x17, 0x80, 0x20, 0x13, 0xc0, 0x20, 0x13, 0xc0, 0x20, 0x11, 0xe0, 0x20, 0x10, 0xf0, 0x20, 0x10, 0xf8, 0x20, 0x10, 0x78, 0x20, 0x10, 0x3c, 0x20, 0x10, 0x1e, 0x20, 0x10, 0x1f, 0x20, 0x10, 0xf, 0x20, 0x10, 0x7, 0xa0, 0x10, 0x3, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x0, 0xe0, 0x38, 0x0, 0x60, 0xfe, 0x0, 0x20}

/* Ograve (210) */
#define NXFONT_METRICS_210 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_210 {0x3, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x30, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_211 {0x0, 0x1, 0x80, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xc, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_212 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xce, 0x0, 0x3, 0x3, 0x0, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {3, 22, 28, 1, 9, 0}
#define NXFONT_BITMAP_213 {0x0, 0xe0, 0x80, 0x1, 0xf9, 0x80, 0x3, 0x3f, 0x0, 0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {3, 22, 28, 1, 9, 0}
#define NXFONT_BITMAP_214 {0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x7, 0x87, 0x80, 0xe, 0x1, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0x70, 0x0, 0x38, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xe, 0x1, 0xc0, 0x7, 0x87, 0x80, 0x1, 0xfe, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_215 {0x40, 0x2, 0xe0, 0x7, 0x70, 0xe, 0x38, 0x1c, 0x1c, 0x38, 0xe, 0x70, 0x7, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0xe, 0x70, 0x1c, 0x38, 0x38, 0x1c, 0x70, 0xe, 0xe0, 0x7, 0x40, 0x2}

/* Oslash (216) */
#define NXFONT_METRICS_216 {3, 22, 27, 1, 12, 0}
#define NXFONT_BITMAP_216 {0x0, 0x0, 0x10, 0x0, 0x0, 0x30, 0x1, 0xfe, 0x60, 0x7, 0x87, 0xc0, 0xe, 0x1, 0xc0, 0x1c, 0x1, 0xe0, 0x38, 0x3, 0x70, 0x38, 0x2, 0x70, 0x70, 0x6, 0x38, 0x70, 0xc, 0x38, 0xf0, 0x8, 0x3c, 0xf0, 0x18, 0x3c, 0xf0, 0x30, 0x3c, 0xf0, 0x60, 0x3c, 0xf0, 0x40, 0x3c, 0xf0, 0xc0, 0x3c, 0xf0, 0x80, 0x3c, 0x71, 0x80, 0x38, 0x73, 0x0, 0x38, 0x3a, 0x0, 0x70, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0x1e, 0x1, 0xc0, 0x37, 0x87, 0x80, 0x21, 0xfe, 0x0, 0x60, 0x0, 0x0, 0x40, 0x0, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_217 {0x0, 0xc0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x18, 0x0, 0x0, 0xc, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0xff, 0x81, 0xfc, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1e, 0x0, 0x60, 0xe, 0x0, 0x40, 0xf, 0x0, 0xc0, 0x7, 0xc3, 0x80, 0x1, 0xfe, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_218 {0x0, 0x1, 0x80, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xc, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0xff, 0x81, 0xfc, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1e, 0x0, 0x60, 0xe, 0x0, 0x40, 0xf, 0x0, 0xc0, 0x7, 0xc3, 0x80, 0x1, 0xfe, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_219 {0x0, 0x18, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xe7, 0x0, 0x1, 0x81, 0x80, 0x1, 0x0, 0x80, 0x0, 0x0, 0x0, 0xff, 0x81, 0xfc, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1e, 0x0, 0x60, 0xe, 0x0, 0x40, 0xf, 0x0, 0xc0, 0x7, 0xc3, 0x80, 0x1, 0xfe, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {3, 22, 28, 1, 9, 0}
#define NXFONT_BITMAP_220 {0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x1, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x81, 0xfc, 0x3e, 0x0, 0x70, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x20, 0x1c, 0x0, 0x60, 0x1e, 0x0, 0x60, 0xe, 0x0, 0x40, 0xf, 0x0, 0xc0, 0x7, 0xc3, 0x80, 0x1, 0xfe, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_221 {0x0, 0x0, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x3, 0x80, 0x0, 0x6, 0x0, 0x0, 0xc, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xfc, 0x3f, 0x0, 0x38, 0x1e, 0x0, 0x30, 0xf, 0x0, 0x60, 0xf, 0x80, 0xc0, 0x7, 0x80, 0x80, 0x3, 0xc1, 0x80, 0x3, 0xc3, 0x0, 0x1, 0xe3, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x38, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xff, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {3, 18, 23, 1, 14, 0}
#define NXFONT_BITMAP_222 {0xff, 0x80, 0x0, 0x3e, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1f, 0xfc, 0x0, 0x1c, 0x1f, 0x0, 0x1c, 0x7, 0x80, 0x1c, 0x3, 0x80, 0x1c, 0x3, 0xc0, 0x1c, 0x1, 0xc0, 0x1c, 0x1, 0xc0, 0x1c, 0x1, 0xc0, 0x1c, 0x3, 0xc0, 0x1c, 0x3, 0x80, 0x1c, 0x7, 0x80, 0x1c, 0x1f, 0x0, 0x1f, 0xfc, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xff, 0x80, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_223 {0x7, 0xc0, 0xc, 0x70, 0x18, 0x38, 0x18, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x30, 0x38, 0x60, 0x39, 0xc0, 0x38, 0x78, 0x38, 0x1c, 0x38, 0x1e, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x3b, 0xc, 0x3b, 0x9c, 0x3b, 0x98, 0xf9, 0xf0}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_224 {0x18, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x1, 0x80, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_225 {0x0, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0xc, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_226 {0x6, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x39, 0xc0, 0x60, 0x60, 0x40, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 13, 21, 1, 16, 0}
#define NXFONT_BITMAP_227 {0x1c, 0x10, 0x3e, 0x30, 0x63, 0xe0, 0x41, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 13, 21, 1, 16, 0}
#define NXFONT_BITMAP_228 {0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_229 {0x7, 0x0, 0xf, 0x80, 0x18, 0xc0, 0x10, 0x40, 0x18, 0xc0, 0xf, 0x80, 0x7, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x60, 0xe0, 0x3, 0xe0, 0xe, 0xe0, 0x18, 0xe0, 0x30, 0xe0, 0x60, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf2, 0xe8, 0x7e, 0xf8, 0x3c, 0x70}

/* ae (230) */
#define NXFONT_METRICS_230 {3, 19, 15, 1, 22, 0}
#define NXFONT_BITMAP_230 {0x1f, 0x9f, 0x0, 0x31, 0xf9, 0xc0, 0x70, 0xe0, 0xc0, 0x70, 0xe0, 0xe0, 0x60, 0xe0, 0xe0, 0x3, 0xff, 0xe0, 0xe, 0xe0, 0x0, 0x18, 0xe0, 0x0, 0x30, 0xe0, 0x0, 0x60, 0xe0, 0x0, 0xe0, 0xe0, 0x20, 0xe1, 0xf0, 0x60, 0xf3, 0x78, 0xc0, 0x7e, 0x3f, 0x80, 0x3c, 0x1f, 0x0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 12, 22, 1, 22, 0}
#define NXFONT_BITMAP_231 {0xf, 0x80, 0x38, 0xc0, 0x70, 0xe0, 0x60, 0xe0, 0xe0, 0x60, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0, 0x4, 0x0, 0xc, 0x0, 0xf, 0x0, 0x3, 0x80, 0x1, 0x80, 0x3, 0x80, 0x1f, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 12, 23, 1, 14, 0}
#define NXFONT_BITMAP_232 {0x30, 0x0, 0x38, 0x0, 0x1c, 0x0, 0x6, 0x0, 0x3, 0x0, 0x1, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x39, 0xc0, 0x60, 0xe0, 0x60, 0x70, 0xc0, 0x70, 0xff, 0xf0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 12, 23, 1, 14, 0}
#define NXFONT_BITMAP_233 {0x1, 0x80, 0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x18, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x39, 0xc0, 0x60, 0xe0, 0x60, 0x70, 0xc0, 0x70, 0xff, 0xf0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 12, 23, 1, 14, 0}
#define NXFONT_BITMAP_234 {0x6, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x39, 0xc0, 0x60, 0x60, 0x40, 0x20, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x39, 0xc0, 0x60, 0xe0, 0x60, 0x70, 0xc0, 0x70, 0xff, 0xf0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 12, 21, 1, 16, 0}
#define NXFONT_BITMAP_235 {0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x39, 0xc0, 0x60, 0xe0, 0x60, 0x70, 0xc0, 0x70, 0xff, 0xf0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x10, 0x70, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0xf, 0x0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 7, 23, 1, 14, 0}
#define NXFONT_BITMAP_236 {0xc0, 0xe0, 0x70, 0x18, 0xc, 0x6, 0x0, 0x0, 0x18, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xfe}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 7, 23, 1, 14, 0}
#define NXFONT_BITMAP_237 {0x6, 0xe, 0x1c, 0x30, 0x60, 0xc0, 0x0, 0x0, 0x18, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xfe}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {2, 10, 23, 0, 14, 0}
#define NXFONT_BITMAP_238 {0xc, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xc0, 0xc0, 0x80, 0x40, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x7c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x7f, 0x0}

/* idieresis (239) */
#define NXFONT_METRICS_239 {2, 9, 21, 0, 16, 0}
#define NXFONT_BITMAP_239 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x7c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x7f, 0x0}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_240 {0x10, 0x0, 0x38, 0x0, 0x1c, 0x70, 0xf, 0xf0, 0xf, 0x0, 0x7f, 0x80, 0x31, 0xc0, 0x0, 0xe0, 0x7, 0xf0, 0x18, 0xf0, 0x30, 0x78, 0x70, 0x38, 0x60, 0x3c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 16, 21, 0, 16, 0}
#define NXFONT_BITMAP_241 {0xe, 0x8, 0x1f, 0x18, 0x31, 0xf0, 0x20, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x18, 0xf0, 0xfb, 0xf8, 0x3e, 0x3c, 0x3c, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0xfe, 0x7f}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_242 {0x18, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x1, 0x80, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_243 {0x0, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0xc, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_244 {0x3, 0x0, 0x7, 0x80, 0xf, 0xc0, 0x1c, 0xe0, 0x30, 0x30, 0x20, 0x10, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 14, 21, 1, 16, 0}
#define NXFONT_BITMAP_245 {0x1c, 0x10, 0x3e, 0x30, 0x63, 0xe0, 0x41, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 14, 21, 1, 16, 0}
#define NXFONT_BITMAP_246 {0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x18, 0xe0, 0x30, 0x70, 0x70, 0x38, 0x60, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x18, 0x70, 0x38, 0x38, 0x30, 0x1c, 0x60, 0x7, 0x80}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 16, 17, 1, 20, 0}
#define NXFONT_BITMAP_247 {0x1, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 14, 21, 1, 19, 0}
#define NXFONT_BITMAP_248 {0x0, 0x18, 0x0, 0x10, 0x0, 0x30, 0x7, 0xa0, 0x18, 0xe0, 0x30, 0xf0, 0x70, 0xb8, 0x61, 0xb8, 0xe1, 0x1c, 0xe1, 0x1c, 0xe3, 0x1c, 0xe2, 0x1c, 0xe6, 0x1c, 0x74, 0x18, 0x74, 0x38, 0x3c, 0x30, 0x1c, 0x60, 0x1f, 0x80, 0x30, 0x0, 0x20, 0x0, 0x60, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_249 {0xc, 0x0, 0xe, 0x0, 0x7, 0x0, 0x1, 0x80, 0x0, 0xc0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x7c, 0x1f, 0xdf, 0xf, 0x98}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_250 {0x0, 0x60, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x0, 0x6, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x7c, 0x1f, 0xdf, 0xf, 0x98}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_251 {0x1, 0x80, 0x3, 0xc0, 0x7, 0xe0, 0xe, 0x70, 0x18, 0x18, 0x10, 0x8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x7c, 0x1f, 0xdf, 0xf, 0x98}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 16, 21, 0, 16, 0}
#define NXFONT_BITMAP_252 {0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x7c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x3c, 0x3c, 0x7c, 0x1f, 0xdf, 0xf, 0x98}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 15, 30, 0, 14, 0}
#define NXFONT_BITMAP_253 {0x0, 0x18, 0x0, 0x38, 0x0, 0x70, 0x0, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x1e, 0x78, 0xc, 0x38, 0xc, 0x3c, 0x8, 0x1c, 0x18, 0x1e, 0x18, 0xe, 0x10, 0xe, 0x30, 0x7, 0x20, 0x7, 0x20, 0x3, 0xe0, 0x3, 0xc0, 0x1, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x3, 0x0, 0x2, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0x38, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 15, 30, 0, 14, 0}
#define NXFONT_BITMAP_254 {0x18, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x39, 0xf0, 0x3b, 0xf8, 0x3e, 0x7c, 0x3c, 0x1c, 0x38, 0x1e, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xe, 0x38, 0xc, 0x38, 0x1c, 0x3c, 0x18, 0x3e, 0x30, 0x3b, 0xe0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0xff, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 15, 28, 1, 16, 0}
#define NXFONT_BITMAP_255 {0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x1e, 0x78, 0xc, 0x38, 0xc, 0x3c, 0x8, 0x1c, 0x18, 0x1e, 0x18, 0xe, 0x10, 0xe, 0x30, 0x7, 0x20, 0x7, 0x20, 0x3, 0xe0, 0x3, 0xc0, 0x1, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 0x2, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0x38, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C" {
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBNX_NXFONTS_NXFONTS_SERIF38X48_H */
