/*
 * Broadcom Proprietary and Confidential. Copyright 2016 Broadcom
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 */

/* Setup options for NetX */

#ifndef NX_USER_H
#define NX_USER_H

#define WICED_CUSTOM_NX_USER_H

/* Setup the characteristics of the Physical layer */
#define NX_PHYSICAL_HEADER          (14 + 12 + 18 )
#define NX_PHYSICAL_TRAILER         (0)
#undef NX_LINK_MTU

#define NX_IP_MAX_REASSEMBLY_TIME   1
#define NX_DHCP_PACKET_PAYLOAD      (NX_BOOT_BUFFER_SIZE + NX_PHYSICAL_HEADER + 20 + 8 + 4 + 100)
#define NX_DHCP_THREAD_PRIORITY     (4)
#define NX_DNS_MAX_RETRIES          (1)
#define NX_IPV6_NEIGHBOR_CACHE_SIZE (1)
#define NX_FTP_NO_FILEX
#define NX_HTTP_NO_FILEX
#define NX_TFTP_NO_FILEX
#define NX_DISABLE_RESET_DISCONNECT
#define NX_DHCP_THREAD_STACK_SIZE   (1152)
#define NX_DHCP_CLIENT_USER_CREATE_PACKET_POOL

#define NX_MAX_PHYSICAL_INTERFACES (2)

#define NX_ENABLE_EXTENDED_NOTIFY_SUPPORT

#define NX_DHCP_CLIENT_RESTORE_STATE

#define NX_TCP_ENABLE_KEEPALIVE

#define NX_ARP_UPDATE_RATE 1

/* This define specifies the maximum packets that are out of order. The default value is 8.  */
#define NX_TCP_MAX_OUT_OF_ORDER_PACKETS 8
#define NX_ARP_DISABLE_AUTO_ARP_ENTRY

#define NX_MAX_LISTEN_REQUESTS 18

#define PACKET_RELEASE_NOTIFY

extern void packet_release_notify( void* pool );
extern UINT nx_rand16( void );

/* Disable parameter checking when building non-debug */
#ifndef DEBUG
#define NX_DISABLE_ERROR_CHECKING
#else
#undef NX_DISABLE_ERROR_CHECKING
#endif






/* This define enabled simple IPv6 multicast group join/leave function.  By default
   the IPv6 multicast join/leave function is not enabled. */
#define NX_IPV6_MULTICAST_ENABLE
#define NX_IPV6_MLD_MULTICAST_ENABLE

/* Disable NetX information gathering */
#define NX_DISABLE_ARP_INFO
#define NX_DISABLE_IP_INFO
#define NX_DISABLE_ICMP_INFO
#define NX_DISABLE_IGMP_INFO
#define NX_DISABLE_PACKET_INFO
#define NX_DISABLE_RARP_INFO
#define NX_DISABLE_TCP_INFO
/* When defines, ARP reply is sent when address conflict occurs. */
/*
#define NX_ARP_DEFEND_BY_REPLY
*/
/*
#define NX_DISABLE_UDP_INFO
*/

extern unsigned long host_rtos_get_tickrate( void );

#define NX_IP_PERIODIC_RATE ( host_rtos_get_tickrate( ) )

#define NX_RANDOM_INITIAL_TCP_PORT

#define NX_ARP_DISABLE_AUTO_ARP_ENTRY

#define NX_IPV6_ADDRESS_CHANGE_NOTIFY_ENABLE

/* To use the ARP collision handler to check for invalid ARP messages
   matching existing entries in the table, enable this feature.  */
/*
#define  NX_ARP_MAC_CHANGE_NOTIFICATION_ENABLE
*/


/* Define the ARP defend interval. The default value is 10 seconds.  */
/*
#define NX_ARP_DEFEND_INTERVAL  10
*/

/* These are all the defines that are used in NetX-Duo #if statements
 * This prevents users changing NetX values to become incompatible with
 * the prebuilt libraries.
 *
 */

#undef OK
#undef SO_PASSCRED
/* #undef TX_ENABLE_EVENT_TRACE */
#undef FD_SETSIZE
#undef ERROR
#undef fd_set
#undef FIONBIO
#undef FIONREAD
#undef htonl
#undef htons
#undef ntohl
#undef ntohs
#undef NX_DHCP_DEFAULT_LEASE_TIME
#undef NX_DHCPV6_DEFAULT_PREFERRED_TIME
#undef NX_DHCPV6_DEFAULT_T1_TIME
#undef NX_DHCPV6_DEFAULT_T2_TIME
#undef NX_DHCPV6_DEFAULT_VALID_TIME
#undef NX_EXTENDED_BSD_LINGER_AND_TIMED_WAIT
#undef NX_HTTP_DIGEST_ENABLE
#undef NX_TELNET_SERVER_PORT
#undef NX_DISABLE_LOOPBACK_INTERFACE
#undef NX_MAX_PHYSICAL_INTERFACES
#undef NX_TCP_IMMEDIATE_ACK
#define NX_TCP_ACK_EVERY_N_PACKETS                      2
#undef NX_MAX_IPV6_ADDRESSES
#undef NX_DISABLE_LOOPBACK_INTERFACE
#undef FEATURE_NX_IPV6
#undef MULTI_HOME_NETX
#undef MULTI_HOME_NETXDUO
#undef NETXDUO_MULTIHOME_SUPPORT
#undef NX_ARP_EXPIRATION_RATE
#undef NX_ARP_MAX_QUEUE_DEPTH
#undef NX_ARP_MAXIMUM_RETRIES
#undef NX_AUTO_IP_ANNOUNCE_INTERVAL
#undef NX_AUTO_IP_ANNOUNCE_NUM
#undef NX_AUTO_IP_ANNOUNCE_WAIT
#undef NX_AUTO_IP_DEFEND_INTERVAL
#undef NX_AUTO_IP_MAX_CONFLICTS
#undef NX_AUTO_IP_PROBE_MAX
#undef NX_AUTO_IP_PROBE_MIN
#undef NX_AUTO_IP_PROBE_NUM
#undef NX_AUTO_IP_PROBE_WAIT
#undef NX_AUTO_IP_RATE_LIMIT_INTERVAL
#undef NX_BSD_LINGER_TIMER_RATE
#undef NX_BSD_MAX_LISTEN_BACKLOG
#undef NX_BSD_MAX_SOCKETS
#undef NX_BSD_PRINT_ERRORS
#undef NX_BSD_SOCKFD_START
#undef NX_BSD_TCP_WINDOW
#undef NX_BSD_TIMED_WAIT_TIMEOUT
#undef NX_BSD_TIMEOUT
#undef NX_BSD_TW_TIMER_RATE
#undef NX_CPU_TICKS_PER_SECOND
#undef NX_CRYPTO_MAX_IV_SIZE_IN_BITS
#undef NX_DELAY_FIRST_PROBE_TIME
#undef NX_DESTIANTION_TABLE_SIZE
#undef NX_DESTINATION_TABLE_SIZE
#undef NX_DHCP_ARP_PROBE_TIMEOUT
#undef NX_DHCP_CLIENT_HOSTNAME_MAX
#undef NX_DHCP_CLIENT_IDENTIFIER_MAX
#undef NX_DHCP_CLIENT_OPTIONS_MAX
#undef NX_DHCP_CLIENT_RECORD_TABLE_SIZE
#undef NX_DHCP_CLIENT_SESSION_TIMEOUT
#undef NX_DHCP_ENABLE_BOOTP
#undef NX_DHCP_FAST_PERIODIC_TIME_INTERVAL
#undef NX_DHCP_FRAGMENT_OPTION
#undef NX_DHCP_IP_ADDRESS_MAX_LIST_SIZE
#undef NX_DHCP_MAX_RETRANS_TIMEOUT
#undef NX_DHCP_MIN_RENEW_TIMEOUT
#undef NX_DHCP_MIN_RETRANS_TIMEOUT
#undef NX_DHCP_MINIMUM_PACKET_PAYLOAD
#undef NX_DHCP_OPTIONAL_SERVER_OPTION_LIST
#undef NX_DHCP_OPTIONAL_SERVER_OPTION_SIZE
#undef NX_DHCP_PACKET_ALLOCATE_TIMEOUT
#undef NX_DHCP_PACKET_POOL_SIZE
#undef NX_DHCP_QUEUE_DEPTH
#undef NX_DHCP_SERVER_HOSTNAME_MAX
#undef NX_DHCP_SERVER_NAME
#undef NX_DHCP_SERVER_THREAD_PRIORITY
#undef NX_DHCP_SERVER_THREAD_STACK_SIZE
#undef NX_DHCP_SLOW_PERIODIC_TIME_INTERVAL
#undef NX_DHCP_SUBNET_MASK
#undef NX_DHCP_TIME_INTERVAL
#undef NX_DHCP_TIME_TO_LIVE
#undef NX_DHCP_TIMEOUT_DECREMENTS
#undef NX_DHCP_TYPE_OF_SERVICE
#undef NX_DHCPV6_DOMAIN_NAME_BUFFER_SIZE
#undef NX_DHCPV6_FRAGMENT_OPTION
#undef NX_DHCPV6_IP_LEASE_TIMER_INTERVAL
#undef NX_DHCPV6_IP_LIFETIME_TIMER_INTERVAL
#undef NX_DHCPV6_MAX_CLIENTS
#undef NX_DHCPV6_MAX_LEASES
#undef NX_DHCPV6_MAX_MESSAGE_SIZE
#undef NX_DHCPV6_MAX_OPTION_REQUEST_OPTIONS
#undef NX_DHCPV6_MUTEX_WAIT
#undef NX_DHCPV6_NUM_DNS_SERVERS
#undef NX_DHCPV6_NUM_TIME_SERVERS
#undef NX_DHCPV6_PACKET_POOL_SIZE
#undef NX_DHCPV6_PACKET_SIZE
#undef NX_DHCPV6_PACKET_TIME_OUT
#undef NX_DHCPV6_PACKET_WAIT_OPTION
#undef NX_DHCPV6_PREFERENCE_VALUE
#undef NX_DHCPV6_QUEUE_DEPTH
#undef NX_DHCPV6_REBIND_TIME
#undef NX_DHCPV6_RENEW_TIME
#undef NX_DHCPV6_SERVER_DUID_TYPE
#undef NX_DHCPV6_SERVER_DUID_VENDOR_ASSIGNED_ID
#undef NX_DHCPV6_SERVER_DUID_VENDOR_ASSIGNED_LENGTH
#undef NX_DHCPV6_SERVER_DUID_VENDOR_PRIVATE_ID
#undef NX_DHCPV6_SERVER_HW_TYPE
#undef NX_DHCPV6_SERVER_THREAD_PRIORITY
#undef NX_DHCPV6_SERVER_THREAD_STACK_SIZE
#undef NX_DHCPV6_SESSION_TIMEOUT
#undef NX_DHCPV6_SESSION_TIMER_INTERVAL
#undef NX_DHCPV6_STATUS_MESSAGE_MAX
#undef NX_DHCPV6_STATUS_MESSAGE_NO_BINDING
#undef NX_DHCPV6_STATUS_MESSAGE_NOT_ON_LINK
#undef NX_DHCPV6_STATUS_MESSAGE_SUCCESS
#undef NX_DHCPV6_STATUS_MESSAGE_UNSPECIFIED
#undef NX_DHCPV6_STATUS_MESSAGE_USE_MULTICAST
#undef NX_DHCPV6_STATUS_NO_ADDRS_AVAILABLE
#undef NX_DHCPV6_THREAD_PRIORITY
#undef NX_DHCPV6_THREAD_STACK_SIZE
#undef NX_DHCPV6_TICKS_PER_SECOND
#undef NX_DHCPV6_TIME_TO_LIVE
#undef NX_DHCPV6_TIME_ZONE_BUFFER_SIZE
#undef NX_DHCPV6_TYPE_OF_SERVICE
#undef NX_DISABLE_EXTENDED_NOTIFY_SUPPORT
#undef NX_DISABLE_IGMPV2
#undef NX_DISABLE_IPV6
#undef NX_DISABLE_IPV6_PATH_MTU_DISCOVERY
#undef NX_DNS_CLIENT_IP_GATEWAY_ADDRESS
#undef NX_DNS_CLIENT_USER_CREATE_PACKET_POOL
#undef NX_DNS_FRAGMENT_OPTION
#undef NX_DNS_MAX_SERVERS
#undef NX_DNS_MESSAGE_MAX
#undef NX_DNS_PACKET_ALLOCATE_TIMEOUT
#undef NX_DNS_PACKET_PAYLOAD_UNALIGNED
#undef NX_DNS_PACKET_POOL_SIZE
#undef NX_DNS_QUEUE_DEPTH
#undef NX_DNS_TIME_TO_LIVE
#undef NX_DNS_TYPE_OF_SERVICE
#undef NX_DUP_ADDR_DETECT_TRANSMITS
#undef NX_ENABLE_IP_STATIC_ROUTING
#undef NX_ENABLE_IPV6_PATH_MTU_DISCOVERY
#undef NX_EXTENDED_BSD_SOCKET_SUPPORT
#undef NX_FTP_ACTIVITY_TIMEOUT
#undef NX_FTP_CLIENT_SOURCE_PORT
#undef NX_FTP_CONTROL_TOS
#undef NX_FTP_CONTROL_WINDOW_SIZE
#undef NX_FTP_DATA_TOS
#undef NX_FTP_DATA_WINDOW_SIZE
#undef NX_FTP_FRAGMENT_OPTION
#undef NX_FTP_MAX_CLIENTS
#undef NX_FTP_PASSWORD_SIZE
#undef NX_FTP_SERVER_PRIORITY
#undef NX_FTP_SERVER_RETRY_MAX
#undef NX_FTP_SERVER_RETRY_SECONDS
#undef NX_FTP_SERVER_RETRY_SHIFT
#undef NX_FTP_SERVER_TIME_SLICE
#undef NX_FTP_SERVER_TIMEOUT
#undef NX_FTP_SERVER_TRANSMIT_QUEUE_DEPTH
#undef NX_FTP_TIME_TO_LIVE
#undef NX_FTP_TIMEOUT_PERIOD
#undef NX_FTP_USERNAME_SIZE
#undef NX_HTTP_CLIENT_MIN_PACKET_SIZE
#undef NX_HTTP_CLIENT_TIMEOUT
#undef NX_HTTP_FRAGMENT_OPTION
#undef NX_HTTP_MAX_NAME
#undef NX_HTTP_MAX_PASSWORD
#undef NX_HTTP_MAX_RESOURCE
#undef NX_HTTP_SERVER_MAX_PENDING
#undef NX_HTTP_SERVER_MIN_PACKET_SIZE
#undef NX_HTTP_SERVER_PRIORITY
#undef NX_HTTP_SERVER_RETRY_MAX
#undef NX_HTTP_SERVER_RETRY_SECONDS
#undef NX_HTTP_SERVER_RETRY_SHIFT
#undef NX_HTTP_SERVER_THREAD_TIME_SLICE
#undef NX_HTTP_SERVER_TIMEOUT
#undef NX_HTTP_SERVER_TRANSMIT_QUEUE_DEPTH
#undef NX_HTTP_SERVER_WINDOW_SIZE
#undef NX_HTTP_TIME_TO_LIVE
#undef NX_HTTP_TYPE_OF_SERVICE
#undef NX_IP_FAST_TIMER_RATE
#undef NX_IP_RAW_MAX_QUEUE_DEPTH
#undef NX_IP_ROUTING_TABLE_SIZE
#undef NX_IP_STATUS_CHECK_WAIT_TIME
#undef NX_IPSEC_ENABLE
#undef NX_IPV6_DEFAULT_ROUTER_TABLE_SIZE
#undef NX_IPV6_HOST_ID_LENGTH
#undef NX_IPV6_PREFIX_LIST_TABLE_SIZE
#undef NX_IPV6_ROUTING_TABLE_SIZE
#undef NX_IPV6_STATELESS_AUTOCONFIG_CONTROL
#undef NX_IPV6_UTIL_INLINE
/* #undef NX_MAX_LISTEN_REQUESTS */
#undef NX_MAX_MULTICAST_GROUPS
#undef NX_MAX_MULTICAST_SOLICIT
#undef NX_MAX_UNICAST_SOLICIT
#undef NX_MICROSECOND_PER_CPU_TICK
#undef NX_ND_MAX_QUEUE_DEPTH
#undef NX_PACKET_ALLOCATE_TIMEOUT
#undef NX_PACKET_HEADER_PAD
#undef NX_PACKET_HEADER_PAD_SIZE
#undef NX_PACKET_OFFSET_ERROR
#undef NX_PATH_MTU_INCREASE_WAIT_INTERVAL
#undef NX_RAW_PACKET_FILTER_ENABLE
#undef NX_REACHABLE_TIME
#undef NX_RETRANS_TIMER
#undef NX_SNMP_AGENT_PORT
#undef NX_SNMP_AGENT_PRIORITY
#undef NX_SNMP_AGENT_TIMEOUT
#undef NX_SNMP_DISABLE_V3
#undef NX_SNMP_FRAGMENT_OPTION
#undef NX_SNMP_MANAGER_TRAP_PORT
#undef NX_SNMP_MAX_CONTEXT_STRING
#undef NX_SNMP_MAX_OCTET_STRING
#undef NX_SNMP_MAX_SECURITY_KEY
#undef NX_SNMP_MAX_USER_NAME
#undef NX_SNMP_NO_SECURITY
#undef NX_SNMP_PACKET_SIZE
#undef NX_SNMP_TIME_TO_LIVE
#undef NX_SNMP_TYPE_OF_SERVICE
#undef NX_SNTP_CLIENT_EXP_BACKOFF_RATE
#undef NX_SNTP_CLIENT_IGNORE_MAX_ADJUST_STARTUP
#undef NX_SNTP_CLIENT_INVALID_UPDATE_LIMIT
#undef NX_SNTP_CLIENT_MAX_QUEUE_DEPTH
#undef NX_SNTP_CLIENT_MAX_ROOT_DISPERSION
#undef NX_SNTP_CLIENT_MAX_TIME_ADJUSTMENT
#undef NX_SNTP_CLIENT_MAX_TIME_LAPSE
#undef NX_SNTP_CLIENT_MIN_NTP_VERSION
#undef NX_SNTP_CLIENT_MIN_SERVER_STRATUM
#undef NX_SNTP_CLIENT_MIN_TIME_ADJUSTMENT
#undef NX_SNTP_CLIENT_NTP_VERSION
#undef NX_SNTP_CLIENT_PACKET_POOL_SIZE
#undef NX_SNTP_CLIENT_PACKET_SIZE
#undef NX_SNTP_CLIENT_PACKET_TIMEOUT
#undef NX_SNTP_CLIENT_PREEMPTION_THRESHOLD
#undef NX_SNTP_CLIENT_RANDOMIZE_ON_STARTUP
#undef NX_SNTP_CLIENT_RTT_REQUIRED
#undef NX_SNTP_CLIENT_SLEEP_INTERVAL
#undef NX_SNTP_CLIENT_THREAD_PRIORITY
#undef NX_SNTP_CLIENT_THREAD_STACK_SIZE
#undef NX_SNTP_CLIENT_THREAD_TIME_SLICE
#undef NX_SNTP_CLIENT_TIME_TO_LIVE
#undef NX_SNTP_CLIENT_UDP_PORT
#undef NX_SNTP_CLIENT_UDP_SOCKET_NAME
#undef NX_SNTP_CLIENT_UNICAST_POLL_INTERVAL
#undef NX_SNTP_DISABLE_ERROR_CHECKING
#undef NX_SNTP_SERVER_UDP_PORT
#undef NX_SNTP_UPDATE_TIMEOUT_INTERVAL
#undef NX_TCP_ACK_TIMER_RATE
#define NX_TCP_ENABLE_WINDOW_SCALING
#undef NX_TCP_FAST_TIMER_RATE
#undef NX_TCP_KEEPALIVE_INITIAL
#undef NX_TCP_KEEPALIVE_RETRIES
#undef NX_TCP_KEEPALIVE_RETRY
#undef NX_TCP_MAXIMUM_RETRIES
#undef NX_TCP_MAXIMUM_TX_QUEUE
#undef NX_TCP_RETRY_SHIFT
#undef NX_TCP_TRANSMIT_TIMER_RATE
#undef NX_TELNET_ACTIVITY_TIMEOUT
#undef NX_TELNET_FRAGMENT_OPTION
#undef NX_TELNET_MAX_CLIENTS
#undef NX_TELNET_MAX_OPTION_SIZE
#undef NX_TELNET_SERVER_PRIORITY
#undef NX_TELNET_SERVER_TIMEOUT
#undef NX_TELNET_SERVER_WINDOW_SIZE
#undef NX_TELNET_TIME_TO_LIVE
#undef NX_TELNET_TIMEOUT_PERIOD
#undef NX_TELNET_TOS
#undef NX_TFTP_ERROR_STRING_MAX
#undef NX_TFTP_FRAGMENT_OPTION
#undef NX_TFTP_MAX_CLIENTS
#undef NX_TFTP_SERVER_PRIORITY
#undef NX_TFTP_SERVER_TIME_SLICE
#undef NX_TFTP_SOURCE_PORT
#undef NX_TFTP_TIME_TO_LIVE
#undef NX_TFTP_TYPE_OF_SERVICE
#undef NX_TRACE_INTERNAL_ARP_REQUEST_RECEIVE
#undef NX_TRACE_OBJECT_TYPE_IP
#undef NXD_TRACE_ICMP_ENABLE
#undef NXDUO_DESTINATION_TABLE_SIZE
#undef NXDUO_DISABLE_DAD
#undef NXDUO_DISABLE_ICMPV6_ERROR_MESSAGE
#undef NXDUO_DISABLE_ICMPV6_REDIRECT_PROCESS
#undef NXDUO_DISABLE_ICMPV6_ROUTER_ADVERTISEMENT_PROCESS
#undef NXDUO_DISABLE_ICMPV6_ROUTER_SOLICITATION
#undef NXDUO_DUP_ADDR_DETECT_TRANSMITS
#undef NXDUO_ICMPV6_MAX_RTR_SOLICITATIONS
#undef NXDUO_ICMPV6_RTR_SOLICITATION_INTERVAL
#undef NX_DISABLE_FRAGMENTATION
#undef NX_DISABLE_ICMP_RX_CHECKSUM
#undef NX_DISABLE_ICMP_TX_CHECKSUM
#undef NTP_SECONDS_AT_01011999
#undef ENABLE_LINGER

#ifdef PLATFORM_L1_CACHE_SHIFT

#include "platform_cache_def.h"

#define NX_PACKET_HEADER_SIZE     104 /* Bytes of header not counting padding. Header can be changed by stack features enabling / disabling. Static assert is added somewhere to make sure header is aligned. */
#define NX_PACKET_HEADER_PAD_SIZE ((PLATFORM_L1_CACHE_ROUND_UP(NX_PACKET_HEADER_SIZE) - NX_PACKET_HEADER_SIZE) / 4)

#if NX_PACKET_HEADER_PAD_SIZE
#define NX_PACKET_HEADER_PAD
#else
#undef NX_PACKET_HEADER_PAD_SIZE
#endif

#endif /* PLATFORM_L1_CACHE_SHIFT */

/* defined in port.h
#define TX_TIMER_PROCESS_IN_ISR
#define TX_DISABLE_ERROR_CHECKING
*/

/* defined in api.h
#define __NETXDUO_MAJOR_VERSION__
#define __NETXDUO_MINOR_VERSION__
*/

/* toolchain defines
#define __time_t_defined
#define __cplusplus
#define DEBUG
*/

#endif

