/*
 * @brief LPC17xx/40xx SPIFI driver
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2012
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef __SPIFI_17XX_40XX_H_
#define __SPIFI_17XX_40XX_H_

#if !defined(CHIP_LPC175X_6X)

#ifdef __cplusplus
extern "C" {
#endif

/** @defgroup SPIFI_17XX_40XX CHIP: LPC17xx/40xx SPIFI Driver
 * @ingroup CHIP_17XX_40XX_Drivers
 * @{
 */

/** SPIFI memory base address */
#define SPIFLASH_BASE_ADDRESS                 (0x28000000)
/** SPIFI API ROM address */
#define SPIFI_ROM_PTR                         (0x1FFF1954)

/**
 * @brief	Initialize the SPIFI
 * @return	None
 */
STATIC INLINE void Chip_SPIFI_Init(void)
{
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SPIFI);
}

/**
 * @brief	Shutdown the SPIFI
 * @return	None
 */
STATIC INLINE void Chip_SPIFI_DeInit(void)
{
	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SPIFI);
}

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* !defined(CHIP_LPC175X_6X) */

#endif /* __SPIFI_17XX_40XX_H_ */
