
ifeq (,$(SYSTEM_PART1_MODULE_VERSION))
$(error SYSTEM_PART1_MODULE_VERSION not defined)
endif

ifeq (,$(SYSTEM_PART2_MODULE_VERSION))
$(error SYSTEM_PART2_MODULE_VERSION not defined)
endif

ifeq (,$(SYSTEM_PART3_MODULE_VERSION))
$(error SYSTEM_PART3_MODULE_VERSION not defined)
endif

ifeq (,$(SYSTEM_PART3_MODULE_DEPENDENCY))
SYSTEM_PART3_MODULE_DEPENDENCY=0,0,0
endif

ifeq (,$(SYSTEM_PART3_MODULE_DEPENDENCY2))
SYSTEM_PART3_MODULE_DEPENDENCY2=0,0,0
endif

GLOBAL_DEFINES += MODULE_VERSION=$(SYSTEM_PART3_MODULE_VERSION)
GLOBAL_DEFINES += MODULE_FUNCTION=$(MODULE_FUNCTION_SYSTEM_PART)
GLOBAL_DEFINES += MODULE_INDEX=3
GLOBAL_DEFINES += MODULE_DEPENDENCY=$(SYSTEM_PART3_MODULE_DEPENDENCY)
GLOBAL_DEFINES += MODULE_DEPENDENCY2=$(SYSTEM_PART3_MODULE_DEPENDENCY2)

LINKER_FILE=$(SYSTEM_PART3_MODULE_PATH)/linker.ld
LINKER_DEPS += $(LINKER_FILE)

LINKER_DEPS += $(SYSTEM_PART3_MODULE_PATH)/module_system_part3_export.ld
LINKER_DEPS += $(SYSTEM_PART2_MODULE_PATH)/module_system_part2_export.ld
LINKER_DEPS += $(SYSTEM_PART1_MODULE_PATH)/module_system_part1_export.ld
LINKER_DEPS += $(USER_PART_MODULE_PATH)/module_user_export.ld

LDFLAGS += --specs=nano.specs -lnosys
LDFLAGS += -L$(SYSTEM_PART1_MODULE_PATH)
LDFLAGS += -L$(SYSTEM_PART2_MODULE_PATH)
LDFLAGS += -L$(SYSTEM_PART3_MODULE_PATH)
LDFLAGS += -L$(USER_PART_MODULE_PATH)
LDFLAGS += -T$(LINKER_FILE)
LDFLAGS += -Wl,--defsym,PLATFORM_DFU=$(PLATFORM_DFU)
LDFLAGS += -Wl,-Map,$(TARGET_BASE).map

CPPSRC += $(call target_files,$(SYSTEM_PART1_MODULE_SRC_PATH),*.cpp)
CSRC += $(call target_files,$(SYSTEM_PART1_MODULE_SRC_PATH),*.c)

BUILTINS_EXCLUDE = malloc free realloc
CFLAGS += $(addprefix -fno-builtin-,$(BUILTINS_EXCLUDE))
