/**
  Copyright (c) 2013-2015 Particle Industries, Inc.  All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation, either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 */

#include "static_assert.h"
#include "hal_platform.h"

#include <stddef.h>

#if HAL_PLATFORM_CLOUD_UDP

// minimal udp public server key
const unsigned char backup_udp_public_server_key[] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
  0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
  0x42, 0x00, 0x04, 0x50, 0x9b, 0xfc, 0x18, 0x56, 0x48, 0xc3, 0x3f, 0x80,
  0x90, 0x7a, 0xe1, 0x32, 0x60, 0xdf, 0x33, 0x28, 0x21, 0x15, 0x20, 0x9e,
  0x54, 0xa2, 0x2f, 0x2b, 0x10, 0x59, 0x84, 0xa4, 0x63, 0x62, 0xc0, 0x7c,
  0x26, 0x79, 0xf6, 0xe4, 0xce, 0x76, 0xca, 0x00, 0x2d, 0x3d, 0xe4, 0xbf,
  0x2e, 0x9e, 0x3a, 0x62, 0x15, 0x1c, 0x48, 0x17, 0x9b, 0xd8, 0x09, 0xdd,
  0xce, 0x9c, 0x5d, 0xc3, 0x0f, 0x54, 0xb8
};

STATIC_ASSERT(backup_udp_public_server_key_size, sizeof(backup_udp_public_server_key)==91);

const size_t backup_udp_public_server_key_size = sizeof(backup_udp_public_server_key);

# if HAL_PLATFORM_MESH

// $id.udp-mesh.particle.io
const unsigned char backup_udp_public_server_address[] = {
  0x01, 0x18, 0x24, 0x69, 0x64, 0x2e, 0x75, 0x64, 0x70, 0x2d, 0x6d, 0x65,
  0x73, 0x68, 0x2e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x2e,
  0x69, 0x6f, 0x00
};

STATIC_ASSERT(backup_udp_public_server_address_size, sizeof(backup_udp_public_server_address)==27);

# else // HAL_PLATFORM_MESH

// $id.udp.particle.io
const unsigned char backup_udp_public_server_address[] = {
  0x01, 0x13, 0x24, 0x69, 0x64, 0x2e, 0x75, 0x64, 0x70, 0x2e, 0x70, 0x61,
  0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x69, 0x6f, 0x00
};

STATIC_ASSERT(backup_udp_public_server_address_size, sizeof(backup_udp_public_server_address)==22);

# endif // !HAL_PLATFORM_MESH

const size_t backup_udp_public_server_address_size = sizeof(backup_udp_public_server_address);

#endif // HAL_PLATFORM_CLOUD_UDP

#if HAL_PLATFORM_CLOUD_TCP
// minimal tcp public server key
const unsigned char backup_tcp_public_server_key[] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
  0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00,
  0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xbe, 0xcc, 0xbe,
  0x43, 0xdb, 0x8e, 0xea, 0x15, 0x27, 0xa6, 0xbb, 0x52, 0x6d, 0xe1, 0x51,
  0x2b, 0xa0, 0xab, 0xcc, 0xa1, 0x64, 0x77, 0x48, 0xad, 0x7c, 0x66, 0xfc,
  0x80, 0x7f, 0xf6, 0x99, 0xa5, 0x25, 0xf2, 0xf2, 0xda, 0xe0, 0x43, 0xcf,
  0x3a, 0x26, 0xa4, 0x9b, 0xa1, 0x87, 0x03, 0x0e, 0x9a, 0x8d, 0x23, 0x9a,
  0xbc, 0xea, 0x99, 0xea, 0x68, 0xd3, 0x5a, 0x14, 0xb1, 0x26, 0x0f, 0xbd,
  0xaa, 0x6d, 0x6f, 0x0c, 0xac, 0xc4, 0x77, 0x2c, 0xd1, 0xc5, 0xc8, 0xb1,
  0xd1, 0x7b, 0x68, 0xe0, 0x25, 0x73, 0x7b, 0x52, 0x89, 0x68, 0x20, 0xbd,
  0x06, 0xc6, 0xf0, 0xe6, 0x00, 0x30, 0xc0, 0xe0, 0xcf, 0xf6, 0x1b, 0x3a,
  0x45, 0xe9, 0xc4, 0x5b, 0x55, 0x17, 0x06, 0xa3, 0xd3, 0x4a, 0xc6, 0xd5,
  0xb8, 0xd2, 0x17, 0x02, 0xb5, 0x27, 0x7d, 0x8d, 0xe4, 0xd4, 0x7d, 0xd3,
  0xed, 0xc0, 0x1d, 0x8a, 0x7c, 0x25, 0x1e, 0x21, 0x4a, 0x51, 0xae, 0x57,
  0x06, 0xdd, 0x60, 0xbc, 0xa1, 0x34, 0x90, 0xaa, 0xcc, 0x09, 0x9e, 0x3b,
  0x3a, 0x41, 0x4c, 0x3c, 0x9d, 0xf3, 0xfd, 0xfd, 0xb7, 0x27, 0xc1, 0x59,
  0x81, 0x98, 0x54, 0x60, 0x4a, 0x62, 0x7a, 0xa4, 0x9a, 0xbf, 0xdf, 0x92,
  0x1b, 0x3e, 0xfc, 0xa7, 0xe4, 0xa4, 0xb3, 0x3a, 0x9a, 0x5f, 0x57, 0x93,
  0x8e, 0xeb, 0x19, 0x64, 0x95, 0x22, 0x4a, 0x2c, 0xd5, 0x60, 0xf5, 0xf9,
  0xd0, 0x03, 0x50, 0x83, 0x69, 0xc0, 0x6b, 0x53, 0xf0, 0xf0, 0xda, 0xf8,
  0x13, 0x82, 0x1f, 0xcc, 0xbb, 0x5f, 0xe2, 0xc1, 0xdf, 0x3a, 0xe9, 0x7f,
  0x5d, 0xe2, 0x7d, 0xb9, 0x50, 0x80, 0x3c, 0x58, 0x33, 0xef, 0x8c, 0xf3,
  0x80, 0x3f, 0x11, 0x01, 0xd2, 0x68, 0x86, 0x5f, 0x3c, 0x5e, 0xe6, 0xc1,
  0x8e, 0x32, 0x2b, 0x28, 0xcb, 0xb5, 0xcc, 0x1b, 0xa8, 0x50, 0x5e, 0xa7,
  0x0d, 0x02, 0x03, 0x01, 0x00, 0x01
};
const unsigned char backup_tcp_public_server_address[] = {
  0x01, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x73, 0x70, 0x61,
  0x72, 0x6b, 0x2e, 0x69, 0x6f, 0x00
};
STATIC_ASSERT(backup_tcp_public_server_key_size, sizeof(backup_tcp_public_server_key)==294);
STATIC_ASSERT(backup_tcp_public_server_address_size, sizeof(backup_tcp_public_server_address)==18);

#endif // HAL_PLATFORM_CLOUD_TCP
