/******************************************************************************
*  Filename:       rf_patch_cpe_multi_protocol_rtls.h
*  Revised:        $Date: 2019-02-27 16:13:01 +0100 (on, 27 feb 2019) $
*  Revision:       $Revision: 18889 $
*
*  Description: RF core patch for multi-protocol support (all available API command sets) with RTLS components in CC13x2 and CC26x2
*
*  Copyright (c) 2015-2019, Texas Instruments Incorporated
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions are met:
*
*  1) Redistributions of source code must retain the above copyright notice,
*     this list of conditions and the following disclaimer.
*
*  2) Redistributions in binary form must reproduce the above copyright notice,
*     this list of conditions and the following disclaimer in the documentation
*     and/or other materials provided with the distribution.
*
*  3) Neither the name of the ORGANIZATION nor the names of its contributors may
*     be used to endorse or promote products derived from this software without
*     specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
*  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
*  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
*  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
*  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
*  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
*  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
*  POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************/
#ifndef _RF_PATCH_CPE_MULTI_PROTOCOL_RTLS_H
#define _RF_PATCH_CPE_MULTI_PROTOCOL_RTLS_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>
#include <string.h>

#ifndef CPE_PATCH_TYPE
#define CPE_PATCH_TYPE static const uint32_t
#endif

#ifndef SYS_PATCH_TYPE
#define SYS_PATCH_TYPE static const uint32_t
#endif

#ifndef PATCH_FUN_SPEC
#define PATCH_FUN_SPEC static inline
#endif

#ifndef _APPLY_PATCH_TAB
#define _APPLY_PATCH_TAB
#endif


CPE_PATCH_TYPE patchImageMultiProtocolRtls[] = {
   0x21004631,
   0x21004683,
   0x21004075,
   0x2100486f,
   0x210040ad,
   0x21004117,
   0x210040d9,
   0x2100492d,
   0x21004139,
   0x21005349,
   0x68084908,
   0x43902221,
   0x48076008,
   0x68c34700,
   0x230260c3,
   0xd1fd1e5b,
   0x68c32210,
   0x60c34393,
   0x4770618a,
   0x40048000,
   0x00005c01,
   0x4801b430,
   0x00004700,
   0x00020efd,
   0x79654c07,
   0xf809f000,
   0x40697961,
   0xd5030749,
   0x4a042101,
   0x60110389,
   0xb570bd70,
   0x47084902,
   0x21000380,
   0x40041108,
   0x0000592d,
   0xf819f000,
   0x296cb2e1,
   0x2804d00b,
   0x2806d001,
   0x490ed107,
   0x07c97809,
   0x7821d103,
   0xd4000709,
   0x490b2002,
   0x210c780a,
   0xd0024211,
   0x22804909,
   0xb003600a,
   0xb5f0bdf0,
   0x4907b083,
   0x48044708,
   0x22407801,
   0x70014391,
   0x47004804,
   0x210000c8,
   0x21000133,
   0xe000e200,
   0x00031641,
   0x00031b23,
   0x21014805,
   0x438a6802,
   0x6b836002,
   0x6383438b,
   0x6002430a,
   0x47004801,
   0x40046000,
   0x00005b3f,
   0x4803b510,
   0x30106800,
   0xfe72f000,
   0x47084901,
   0x21000108,
   0x000095e3,
   0x4cffb570,
   0x5d002044,
   0x008049fe,
   0x68801840,
   0x46054780,
   0xd0112801,
   0x5d00207e,
   0xd30d2805,
   0x06002021,
   0x00897e41,
   0x7f0a1809,
   0xd0072a02,
   0x77082003,
   0x49f43480,
   0x478888a0,
   0xbd704628,
   0x77012104,
   0x700148f1,
   0xb5ffe7f4,
   0x7e934aec,
   0x49ef185b,
   0x3280600b,
   0x09897891,
   0x49edd16e,
   0x29006909,
   0x680bd06a,
   0x041bb2da,
   0x4be40e1c,
   0x7edb3360,
   0xd01b2c01,
   0x005b2410,
   0x1edb46a6,
   0x4be5469c,
   0x681b684d,
   0x00923108,
   0x1f121852,
   0x9202402b,
   0x4ae13030,
   0x93002401,
   0x60549103,
   0x26224adf,
   0x27106914,
   0x6114433c,
   0xe0302200,
   0x009b2408,
   0x1f9b46a6,
   0xc910e7e2,
   0x40634fd9,
   0x9301402b,
   0x24014623,
   0x603c0364,
   0x34404cd3,
   0x4cd26060,
   0x68643c40,
   0xd5061a24,
   0x3c804cd1,
   0x04bf6827,
   0xbf20d401,
   0x4fcbe7fa,
   0x633c9c01,
   0x44709c02,
   0xd90042a1,
   0x4cc59903,
   0x42346864,
   0x4cc3d006,
   0x68263c80,
   0x43be2702,
   0x26006026,
   0x45621c52,
   0x9c00d3d1,
   0x405c49c0,
   0x3940402c,
   0x1a12684a,
   0x48bcd4fc,
   0x48bc6304,
   0x60412100,
   0x690248bb,
   0x438a2110,
   0xbdff6102,
   0x212248b4,
   0x420a6842,
   0x4ab2d0fc,
   0x68103a80,
   0x43882102,
   0xbdff6010,
   0x4daab5f3,
   0x5d46202f,
   0xb08148b2,
   0x05806900,
   0x2e011600,
   0x1c40d002,
   0xe0001040,
   0x49ad301e,
   0x6a093140,
   0x4ba14aac,
   0x691a4351,
   0x6a1b0e09,
   0xd0222e01,
   0x01591852,
   0x316731ff,
   0x18544b9f,
   0x68d93340,
   0xb2894fa0,
   0xb2821a08,
   0x68783f40,
   0xd4fc1b00,
   0x462860da,
   0x90003060,
   0x49958381,
   0x31122050,
   0x35804788,
   0x980180a8,
   0xd0082800,
   0x990278aa,
   0xfabef000,
   0x1852e007,
   0x31ce0119,
   0x4896e7dc,
   0x99006ac0,
   0x489577c8,
   0x68407829,
   0x08c14348,
   0xd00b2e01,
   0x38134620,
   0x687a340e,
   0xd4fc1b12,
   0x0c0b4a8f,
   0xb2896193,
   0xbdfe6151,
   0x38114620,
   0xe7f23409,
   0x4c7cb570,
   0x35604625,
   0x1e407fa8,
   0xd80d2802,
   0x28006aa0,
   0x2182d004,
   0x70015d09,
   0x62a01c40,
   0x1e406a60,
   0x7fa86260,
   0x77a81cc0,
   0x28057fa8,
   0xd112d322,
   0x28026a60,
   0x497ddd08,
   0x47881e80,
   0x62611c81,
   0xd0012800,
   0xbd702001,
   0x46082100,
   0xff7af7ff,
   0xf7ff2110,
   0x486afef2,
   0x6ac13840,
   0xd0fc07c9,
   0x38804867,
   0x22026801,
   0x60014311,
   0x8ba84964,
   0x60c83140,
   0x36404626,
   0x495e7930,
   0x18400080,
   0x47806880,
   0xd1de2800,
   0x29057fa9,
   0x7fead301,
   0x29047172,
   0x7de1d3d7,
   0xd1022900,
   0x29007e21,
   0x7eead0d1,
   0x015268e1,
   0x60e11889,
   0xb570bd70,
   0x20444d4f,
   0x48535d46,
   0x3820494e,
   0x00b07ec4,
   0x68801840,
   0x4b5a4780,
   0x781a09a1,
   0xd10a4211,
   0x21ff2221,
   0x76510612,
   0x22004948,
   0x600a1f09,
   0x2101604a,
   0x212f7019,
   0x29025d49,
   0x2e31d008,
   0x07e1d003,
   0xd0032900,
   0x0861e003,
   0xe7f907c9,
   0x35802400,
   0xbd70706c,
   0x4c39b5f8,
   0x46272500,
   0x723d3760,
   0x5d00202f,
   0xd03a2802,
   0x47804845,
   0x36404626,
   0x7ff04937,
   0x62203920,
   0x43087849,
   0x48347560,
   0x38406265,
   0x2d007fc5,
   0x7d20d006,
   0x43082120,
   0x06e87520,
   0x72380ec0,
   0x7f30493a,
   0x4a3a4788,
   0xd0112d00,
   0x61c54839,
   0x20074b28,
   0x63983b40,
   0x21054d26,
   0x07806950,
   0x6868d1fc,
   0xd0f94208,
   0x30404831,
   0x63186800,
   0x28007f30,
   0x6e60d001,
   0x6be16210,
   0x47882039,
   0x20006420,
   0x482cbdf8,
   0xb5f0e7fa,
   0x20444915,
   0x2b045c43,
   0x460ad00a,
   0x78103268,
   0x28004f12,
   0x28ffd070,
   0x2b04d012,
   0xe006d003,
   0x327b460a,
   0x68cce7f3,
   0x19640145,
   0x242f60cc,
   0x2c015c64,
   0x0640d101,
   0x62480e00,
   0x701020ff,
   0x4c09202f,
   0x60200200,
   0x6a484d07,
   0x68623d40,
   0xd03f07d2,
   0xe02b220f,
   0x21000160,
   0x00025500,
   0x0000423d,
   0x21000020,
   0x40045080,
   0x210000e8,
   0x40022080,
   0x40043040,
   0xe000ed00,
   0xe000e280,
   0x400452c0,
   0x00155556,
   0x40046040,
   0x210002c0,
   0x40045180,
   0x0002175f,
   0x210004e0,
   0x00020749,
   0x00020e45,
   0x40042000,
   0x40042100,
   0x0002469d,
   0x4ec363aa,
   0x2801e003,
   0x632edd07,
   0x28001e80,
   0x6862dd1a,
   0xd1f607d2,
   0x2007e006,
   0x20ff63a8,
   0xe0116328,
   0xdd0f2800,
   0x26146862,
   0xd0b64232,
   0x7b524ab8,
   0x60220212,
   0x22084bb7,
   0x4bb7601a,
   0x6248601a,
   0xbdf02001,
   0x19c00098,
   0x64086880,
   0xbdf02000,
   0x460148b2,
   0x7bca3120,
   0x76823060,
   0x73c82002,
   0x470048af,
   0xb50049ad,
   0x71083140,
   0xd01c2831,
   0x4603dc08,
   0xfec0f000,
   0x0e13190a,
   0x0e0e150e,
   0x0e1d1b0e,
   0xd0122835,
   0xd0122836,
   0xd00a2838,
   0xd006283b,
   0x008049a3,
   0x68801840,
   0x48a2bd00,
   0x48a2bd00,
   0x48a2bd00,
   0x48a2bd00,
   0x48a2bd00,
   0x48a2bd00,
   0xb5f0bd00,
   0xb0854c98,
   0x31204621,
   0x7bce9103,
   0x5d092144,
   0xd0012907,
   0xd17e2934,
   0x35804625,
   0x2a00786a,
   0x7d21d07a,
   0xd5770689,
   0x3180498b,
   0x7f09468e,
   0xd0282e01,
   0x0f090709,
   0x702b004b,
   0x025b2301,
   0x2300469c,
   0x93029300,
   0xd0302900,
   0x4f8e0993,
   0xd00b07db,
   0x2b007f3b,
   0x23f7d001,
   0x4b8a401a,
   0x781b3320,
   0xd0012b00,
   0x401a23ef,
   0x0f5b0693,
   0xd00b2b07,
   0x07db08d3,
   0x2200d00c,
   0x4a82767a,
   0x9200321c,
   0x0909e013,
   0xe7d77029,
   0x02922201,
   0xe7f24694,
   0x07d20912,
   0x2201d008,
   0x4a7a767a,
   0x92003220,
   0x02522201,
   0xe0009202,
   0x4a772100,
   0x63d32307,
   0x4a752322,
   0x68523240,
   0xd0fa421a,
   0x6b524a72,
   0x61da4b72,
   0x693b4f72,
   0x43932210,
   0x4b71613b,
   0x0792695a,
   0x4a6fd1fc,
   0x68123240,
   0x06d370aa,
   0x1e9a0edb,
   0xd3002a13,
   0x46222302,
   0x92013260,
   0x76d33008,
   0xd0552900,
   0x7f7f4677,
   0x469600da,
   0x2a041bd2,
   0x2204da00,
   0xd0232e01,
   0x330e0093,
   0xe052e001,
   0x4e60e04e,
   0x467362b3,
   0x485a181b,
   0x434a6203,
   0x45624617,
   0x4667dd00,
   0x9902485b,
   0x99026041,
   0x1e4919c9,
   0x68016081,
   0x43112221,
   0x6a266001,
   0x62261c76,
   0x98036266,
   0x28017bc0,
   0xe00ad006,
   0x4f5000d6,
   0x62be3616,
   0xe7dd011b,
   0x494f4849,
   0xf7ff3040,
   0x2e02fc48,
   0x78aadd06,
   0x98004639,
   0xf85cf000,
   0xe00f2102,
   0x98004639,
   0xfd5cf7ff,
   0x31404946,
   0x9a016ac9,
   0x210077d1,
   0xd0002e01,
   0xf7ff2108,
   0x2103fccc,
   0x77819801,
   0xbdf0b005,
   0x21019a01,
   0x6a217791,
   0x62211c49,
   0xe0026261,
   0x34602100,
   0x4a3777a1,
   0x62912100,
   0x62084931,
   0x7bc09803,
   0xd1e92801,
   0x3040482e,
   0x06c968c1,
   0x2100d5fc,
   0x29021c49,
   0x4930dbfc,
   0xfc0bf7ff,
   0x481ee7dc,
   0x4601b510,
   0x460a3160,
   0x232f7e89,
   0x29025419,
   0x7d01d010,
   0xd5130689,
   0x29016a01,
   0x6ec1dd10,
   0x06c97849,
   0x1e8b0ec9,
   0xd8092b12,
   0x1e5b7d43,
   0xe0067543,
   0xfbfcf7ff,
   0xd0002800,
   0xbd102001,
   0x76d12100,
   0xbd102000,
   0x33804b1b,
   0x7083695b,
   0x22017042,
   0x42910252,
   0x2102dd03,
   0x71017001,
   0x21014770,
   0x47707001,
   0x0000ffff,
   0x21000048,
   0xe000e280,
   0xe000e100,
   0x21000160,
   0x00020f47,
   0x00025500,
   0x2100461d,
   0x21004517,
   0x21004489,
   0x2100442f,
   0x2100437d,
   0x21004171,
   0x21000000,
   0x40045040,
   0x40042100,
   0x400451c0,
   0x40042000,
   0x40045300,
   0x40048000,
   0x40046000,
   0x490cb510,
   0x4a0c4788,
   0x5e512106,
   0xd0072900,
   0xd0052902,
   0xd0032909,
   0xd0012910,
   0xd1072911,
   0x43c92177,
   0xdd014288,
   0xdd012800,
   0x43c0207f,
   0x0000bd10,
   0x000065a9,
   0x21000380,
   0x2500b570,
   0x614548ff,
   0xf000207d,
   0x4cfefcfd,
   0x07c06ae0,
   0x62e5d0fc,
   0xf0002082,
   0x48fbfcf5,
   0x07c96ac1,
   0x62c5d0fc,
   0x60a12101,
   0x60a56025,
   0x384048f6,
   0x60056081,
   0xbd706085,
   0x4bf4b530,
   0x68db685b,
   0xd00d2b00,
   0x189c0852,
   0x4def4aef,
   0xe0053240,
   0x079b6853,
   0x6b6bd5fc,
   0x1c405423,
   0xdbf74288,
   0xb5f7bd30,
   0x2400468e,
   0x00c9214b,
   0x49e8468c,
   0x684e4627,
   0x46254623,
   0x62544ae6,
   0x6ad24ae1,
   0x4ae307d1,
   0x68520fc9,
   0x42821b92,
   0x2701d900,
   0x6a524ae0,
   0xd006429a,
   0x684648dd,
   0x46604bde,
   0xb29d6adb,
   0x29014613,
   0x2f00d001,
   0x4ad6d0e6,
   0x6ad16ad0,
   0x0fc006c0,
   0x0fc90689,
   0x29014ed3,
   0x2801d101,
   0x210fd011,
   0x020968b0,
   0x1d404008,
   0x48cc6190,
   0x62c12100,
   0x62012101,
   0x68784fcc,
   0x99026130,
   0xd00e2902,
   0x9802e013,
   0xd1032802,
   0x684048c7,
   0x61486871,
   0x20004671,
   0xf7ff9a02,
   0x2401ff9b,
   0x6871e7ea,
   0x8d892c01,
   0x1a40d01c,
   0x48c160f0,
   0x0a2a6ac0,
   0x0a08b281,
   0xb2c91880,
   0x1889b2ea,
   0x084a0840,
   0x23ff1811,
   0x1a103301,
   0x02001a59,
   0xfc6cf000,
   0x68706170,
   0x8d828873,
   0x18d56931,
   0xe00468f0,
   0x30f01a40,
   0x6879e7e0,
   0x1a096131,
   0xd3fa42a9,
   0x21009d02,
   0xd0052d02,
   0xd1032c01,
   0x1a086931,
   0x1ac11a80,
   0x1a406930,
   0x2c0160f0,
   0x2000d002,
   0xbdfe43c0,
   0xbdfe2000,
   0x4ba6b510,
   0x2402499e,
   0x28002201,
   0x48a4d007,
   0x694861d8,
   0x61484390,
   0x43206948,
   0x48a1e006,
   0x694861d8,
   0x61484310,
   0x43a06948,
   0x499b6148,
   0x6bc83940,
   0x40184b9c,
   0x43032303,
   0x431063cb,
   0xbd1063c8,
   0x9c02b510,
   0x02240112,
   0x3c013cff,
   0x43143a10,
   0x430c1e49,
   0x61cc498b,
   0x4b8a624b,
   0x3b402202,
   0x2200605a,
   0x620a62ca,
   0x02004a87,
   0x79926852,
   0xd0022a02,
   0x61881cc0,
   0x1d00bd10,
   0x7808e7fb,
   0x62c84983,
   0x49804770,
   0x68896849,
   0xd0042900,
   0x18080840,
   0x7800497e,
   0x487a62c8,
   0x38402103,
   0x60416001,
   0x20014976,
   0x60486008,
   0xb5384770,
   0xf7ff4605,
   0x4872ffe8,
   0x62c12100,
   0x62012108,
   0x78234c71,
   0x68a09300,
   0x05004b77,
   0x78620f00,
   0xffb6f7ff,
   0xf7ff2000,
   0x6861ff91,
   0x68082d02,
   0x8dc8d100,
   0x2101462a,
   0xfef9f7ff,
   0xb5f7bd38,
   0x46154966,
   0x684a2000,
   0x46944607,
   0x6ac94960,
   0x496207ce,
   0x68490ff6,
   0x1a8a4662,
   0x428a9900,
   0x2701d900,
   0x6a4c495e,
   0xd0074284,
   0xd0012c00,
   0xe0002001,
   0xf7ff2000,
   0x4620ff69,
   0xd0012e01,
   0xd0e32f00,
   0x21004851,
   0x4a526141,
   0x4e526ad0,
   0x0fc006c0,
   0xd1032d00,
   0x685b4b50,
   0x61636874,
   0xd0012f00,
   0xd01d2800,
   0x462a2401,
   0x99012000,
   0xfea8f7ff,
   0x6ac0484b,
   0xb2810223,
   0xb2ca0a08,
   0x1a101811,
   0x02001a59,
   0xfb88f000,
   0x4a436170,
   0x61316851,
   0x79836870,
   0x432f461f,
   0x2b01d00e,
   0xe01ad014,
   0x68b0230f,
   0x4018021b,
   0x61901d40,
   0x62c14837,
   0x62012101,
   0xe7e82400,
   0x2c008d83,
   0x1ac9d002,
   0xe00731f0,
   0xe0051ac9,
   0xd1042d00,
   0x1ac98d83,
   0x310531ff,
   0x8d8160f1,
   0x23008877,
   0x19c9468c,
   0x68f06932,
   0x4a2ce002,
   0x61326852,
   0x428a1a12,
   0x2d00d3f9,
   0x2c00d006,
   0x6931d004,
   0x46601a09,
   0x1bc31a08,
   0x1ac06930,
   0x2c0060f0,
   0x2000d001,
   0x2000bdfe,
   0xbdfe43c0,
   0x4605b538,
   0xff39f7ff,
   0x2100481a,
   0x210862c1,
   0x4c1a6201,
   0x93007823,
   0x4b2068a0,
   0x0f000500,
   0xf7ff7862,
   0x2000ff07,
   0xfee2f7ff,
   0x2d006861,
   0xd1006808,
   0x462a8dc8,
   0xf7ff2101,
   0xbd38ff52,
   0x4c0db530,
   0x62e52500,
   0x3a100112,
   0x430a1e49,
   0x626361e2,
   0x1c800200,
   0x480961a0,
   0x60012101,
   0x61456942,
   0x32404a06,
   0x68406011,
   0xe0173028,
   0x40041100,
   0x40046000,
   0x40045040,
   0x210053e8,
   0x40043000,
   0x40045300,
   0x400451c0,
   0x40044040,
   0x08180532,
   0x0818070e,
   0xfff000ff,
   0x0000aaaa,
   0x318049ff,
   0xbd306008,
   0x4605b538,
   0xfee5f7ff,
   0x210048fc,
   0x210662c1,
   0x4cfb6201,
   0x78232108,
   0x68a09300,
   0x05004bf9,
   0x78620f00,
   0xffb8f7ff,
   0x48f749f8,
   0x200161c8,
   0xfe8af7ff,
   0x462a6860,
   0x21016800,
   0xfefdf7ff,
   0xb530bd38,
   0x4bf24df2,
   0x35804cf2,
   0xd00e2a40,
   0x58420089,
   0x625a0c12,
   0xb2925842,
   0x1808629a,
   0x0c096841,
   0x684062a1,
   0x6328b280,
   0x00c9bd30,
   0x0c125842,
   0x584262da,
   0x631ab292,
   0x68411808,
   0x62590c09,
   0xb2896841,
   0x68816299,
   0x49e00c0a,
   0x634a31c0,
   0xb2926882,
   0x68c1638a,
   0x62a10c09,
   0xe7e168c0,
   0x4606b5f0,
   0x2080b089,
   0xfa8ef000,
   0x2500b662,
   0x204f4cd2,
   0x60e56066,
   0x00c049d6,
   0x47889501,
   0x68606125,
   0x290079c1,
   0x21ffd001,
   0x30203101,
   0x4acf60a1,
   0x62117901,
   0x21207902,
   0xd1002a00,
   0x70212140,
   0x21027980,
   0xd1002800,
   0x48ca2101,
   0x47807061,
   0x49c06860,
   0x79403020,
   0x62c83180,
   0x478048c6,
   0x80602000,
   0x384048bf,
   0x48c56bc0,
   0x610149c3,
   0x90002000,
   0x684849b8,
   0x24003020,
   0x46267c40,
   0x46259405,
   0x90029403,
   0x48b3e20c,
   0x4ab02700,
   0x68506147,
   0x31504601,
   0x48ade001,
   0x42886840,
   0x48b8d3fb,
   0x48b64780,
   0x48b76147,
   0x7ac07ac1,
   0x0fc907c9,
   0x40102202,
   0xd0024301,
   0xb00948b3,
   0x48a5bdf0,
   0x80412100,
   0x97076847,
   0x7cf93720,
   0x90060860,
   0xfa32f000,
   0xd1142900,
   0x42a09805,
   0x9802d011,
   0xd03b2800,
   0x07c09902,
   0x0fc00849,
   0x28009102,
   0x7cb8d002,
   0x90024048,
   0x98027c39,
   0xfa1cf000,
   0x9807460d,
   0x6b409405,
   0x5bc200ef,
   0x428a9900,
   0x1db9d02e,
   0x1d395a43,
   0x5c439300,
   0x5c421cb9,
   0x5c411cf9,
   0xf000200e,
   0x488afa0d,
   0x68402201,
   0x6b402300,
   0x5bc04611,
   0xf0000400,
   0x488dfa09,
   0x48924780,
   0x29037801,
   0x4882d1fc,
   0x8f096841,
   0x497e8041,
   0x46026848,
   0xe0073238,
   0x7c381c6d,
   0x42a8b2ed,
   0x2500d8cd,
   0x6848e7cb,
   0xd3fc4290,
   0x68404878,
   0x5bc06b40,
   0x48799000,
   0x68813840,
   0xf000207e,
   0x4873f9eb,
   0x6a386847,
   0xd0062800,
   0x46200041,
   0xf9d0f000,
   0xd0052900,
   0x496de014,
   0x780a69b8,
   0xe0334621,
   0xd00b2c00,
   0x30204638,
   0x07ca7fc1,
   0x2201d018,
   0x43917782,
   0x496f77c1,
   0x608802d0,
   0x900469b8,
   0x90076a38,
   0x46200041,
   0xf9b2f000,
   0x42819807,
   0x2c00d113,
   0x4638d00f,
   0x7fc13020,
   0xd401078a,
   0xe7664869,
   0x77822202,
   0x401122fd,
   0x200177c1,
   0x02c04960,
   0x69f86088,
   0x46209004,
   0xf0006a39,
   0x4852f997,
   0x98047802,
   0xfec1f7ff,
   0xd1042c00,
   0x6840484e,
   0x28027980,
   0x9806d00c,
   0x484b9001,
   0x79806840,
   0xd0072801,
   0x28004f48,
   0x2802d058,
   0xe078d07e,
   0xe12f2402,
   0xf7ff4620,
   0xb280fe87,
   0x48414684,
   0x6ac33040,
   0x68504a40,
   0x98016907,
   0x1d4800c1,
   0x6850543b,
   0x1d086903,
   0x4660541d,
   0xd00e2800,
   0x20006852,
   0x691243c0,
   0x50502c00,
   0xe002d167,
   0xb2a41ca4,
   0x9803e053,
   0x90031c40,
   0x6857e04f,
   0x5dc02027,
   0xd0012801,
   0xe0146950,
   0x30804832,
   0x071b6a83,
   0x61530f1b,
   0x05806a80,
   0x2b070e80,
   0x3b10dd01,
   0x281f6153,
   0x3840dd01,
   0x0100b200,
   0x010018c0,
   0x30ff6150,
   0x30014b33,
   0xd3014298,
   0x61502000,
   0x30804824,
   0x69536a40,
   0x18c00200,
   0x5058693b,
   0xb2816950,
   0xe0ca207f,
   0xf7ff4620,
   0xb281fddf,
   0x30404817,
   0x48176ac3,
   0x69076840,
   0x00c09801,
   0x54bb1d42,
   0x1d034a13,
   0x29006852,
   0x54d56912,
   0x4910d04e,
   0x68492200,
   0x690943d2,
   0x500a2c00,
   0x1c76d0af,
   0x2c01b2b6,
   0xf7ffd8a8,
   0x4809fbf5,
   0x8d386847,
   0xe00042b0,
   0xd303e040,
   0x99038d7a,
   0xd27e428a,
   0x42884914,
   0xe054e028,
   0x40043000,
   0x40046000,
   0x210053e8,
   0x0000aaaa,
   0x08180532,
   0x40044040,
   0x40045140,
   0x40045300,
   0x0000424f,
   0x00009083,
   0x00004be3,
   0x0000c210,
   0x40041100,
   0x00000de5,
   0x21000128,
   0x04040003,
   0x210002e4,
   0x04060003,
   0x00000201,
   0x0000ffff,
   0x8d78d102,
   0xd06f4288,
   0x484d2101,
   0x60810449,
   0xe684484c,
   0x21004a4c,
   0x69126852,
   0xe75f5011,
   0xf7ff4620,
   0xb282fcc6,
   0x46946878,
   0x98016903,
   0x00c04639,
   0x549d1d02,
   0x6ad34a44,
   0x6917687a,
   0x54bb1d42,
   0x2a004662,
   0x6849d00a,
   0x43d22200,
   0x2c026909,
   0xd800500a,
   0x1c76e745,
   0xe73fb2b6,
   0x68494939,
   0x3120468c,
   0x290179c9,
   0x4938d125,
   0x07136a8a,
   0x0f1b4a37,
   0x6a896997,
   0x0f3f073f,
   0x69920589,
   0x05920e89,
   0x2b070e92,
   0x3b10dd00,
   0xdd002f07,
   0x291f3f10,
   0x3940dd01,
   0x2a1fb209,
   0x3a40dd03,
   0xe01fe000,
   0x0109b212,
   0x19c918c9,
   0x18890112,
   0x4924010a,
   0x4923614a,
   0x694a4b26,
   0x320132ff,
   0xd301429a,
   0x614a2200,
   0x6a524a20,
   0x0212694b,
   0x466218d3,
   0x50136912,
   0xb2816948,
   0xf0002083,
   0xe6fbf873,
   0x98018fb9,
   0xf856f000,
   0xd1072900,
   0x28009801,
   0x8778d004,
   0x48102101,
   0x608103c9,
   0x68414810,
   0x42a18889,
   0xe5ecd900,
   0x480b2101,
   0x60810409,
   0x1e49480b,
   0x8d026840,
   0xd103428a,
   0x42888d40,
   0xe5d3d100,
   0x98014906,
   0x87486849,
   0xf0002081,
   0x2000f825,
   0x0000e5ef,
   0x40041100,
   0x04030003,
   0x210053e8,
   0x40046040,
   0x400451c0,
   0x40045080,
   0x00000201,
   0x49068800,
   0xd1064288,
   0x21004805,
   0x49058501,
   0x20016241,
   0x20824770,
   0x00004770,
   0x00006801,
   0x21000108,
   0x21004159,
   0x4801b403,
   0xbd019001,
   0x00003cc3,
   0x4801b403,
   0xbd019001,
   0x0000937d,
   0x4801b403,
   0xbd019001,
   0x00009361,
   0x4801b403,
   0xbd019001,
   0x0000867b,
   0x4801b403,
   0xbd019001,
   0x000049a3,
   0x4801b403,
   0xbd019001,
   0x00003c8f,
   0x4801b403,
   0xbd019001,
   0x00003ca9,
   0x4674b430,
   0x78251e64,
   0x42ab1c64,
   0x461dd200,
   0x005b5d63,
   0xbc3018e3,
   0x00004718,
   0x08180532,
   0x0818070e,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
};
#define _NWORD_PATCHIMAGE_MULTI_PROTOCOL_RTLS 1261

CPE_PATCH_TYPE patchCpeHd[] = {
   0x00000000,
};
#define _NWORD_PATCHCPEHD_MULTI_PROTOCOL_RTLS 1

#define _NWORD_PATCHSYS_MULTI_PROTOCOL_RTLS 0



#ifndef _MULTI_PROTOCOL_RTLS_SYSRAM_START
#define _MULTI_PROTOCOL_RTLS_SYSRAM_START 0x20000000
#endif

#ifndef _MULTI_PROTOCOL_RTLS_CPERAM_START
#define _MULTI_PROTOCOL_RTLS_CPERAM_START 0x21000000
#endif

#define _MULTI_PROTOCOL_RTLS_SYS_PATCH_FIXED_ADDR 0x20000000

#define _MULTI_PROTOCOL_RTLS_PATCH_VEC_ADDR_OFFSET 0x03D0
#define _MULTI_PROTOCOL_RTLS_PATCH_TAB_OFFSET 0x03D4
#define _MULTI_PROTOCOL_RTLS_IRQPATCH_OFFSET 0x0480
#define _MULTI_PROTOCOL_RTLS_PATCH_VEC_OFFSET 0x404C

#define _MULTI_PROTOCOL_RTLS_PATCH_CPEHD_OFFSET 0x04E0

#ifndef _MULTI_PROTOCOL_RTLS_NO_PROG_STATE_VAR
static uint8_t bMultiProtocolRtlsPatchEntered = 0;
#endif

PATCH_FUN_SPEC void enterMultiProtocolRtlsCpePatch(void)
{
#if (_NWORD_PATCHIMAGE_MULTI_PROTOCOL_RTLS > 0)
   uint32_t *pPatchVec = (uint32_t *) (_MULTI_PROTOCOL_RTLS_CPERAM_START + _MULTI_PROTOCOL_RTLS_PATCH_VEC_OFFSET);

   memcpy(pPatchVec, patchImageMultiProtocolRtls, sizeof(patchImageMultiProtocolRtls));
#endif
}

PATCH_FUN_SPEC void enterMultiProtocolRtlsCpeHdPatch(void)
{
#if (_NWORD_PATCHCPEHD_MULTI_PROTOCOL_RTLS > 0)
   uint32_t *pPatchCpeHd = (uint32_t *) (_MULTI_PROTOCOL_RTLS_CPERAM_START + _MULTI_PROTOCOL_RTLS_PATCH_CPEHD_OFFSET);

   memcpy(pPatchCpeHd, patchCpeHd, sizeof(patchCpeHd));
#endif
}

PATCH_FUN_SPEC void enterMultiProtocolRtlsSysPatch(void)
{
}

PATCH_FUN_SPEC void configureMultiProtocolRtlsPatch(void)
{
   uint8_t *pPatchTab = (uint8_t *) (_MULTI_PROTOCOL_RTLS_CPERAM_START + _MULTI_PROTOCOL_RTLS_PATCH_TAB_OFFSET);


   pPatchTab[1] = 0;
   pPatchTab[18] = 1;
   pPatchTab[81] = 2;
   pPatchTab[26] = 3;
   pPatchTab[76] = 4;
   pPatchTab[62] = 5;
   pPatchTab[64] = 6;
   pPatchTab[91] = 7;
   pPatchTab[79] = 8;
   pPatchTab[168] = 9;
}

PATCH_FUN_SPEC void applyMultiProtocolRtlsPatch(void)
{
#ifdef _MULTI_PROTOCOL_RTLS_NO_PROG_STATE_VAR
   enterMultiProtocolRtlsSysPatch();
   enterMultiProtocolRtlsCpePatch();
#else
   if (!bMultiProtocolRtlsPatchEntered)
   {
      enterMultiProtocolRtlsSysPatch();
      enterMultiProtocolRtlsCpePatch();
      bMultiProtocolRtlsPatchEntered = 1;
   }
#endif
   enterMultiProtocolRtlsCpeHdPatch();
   configureMultiProtocolRtlsPatch();
}

PATCH_FUN_SPEC void refreshMultiProtocolRtlsPatch(void)
{
   enterMultiProtocolRtlsCpeHdPatch();
   configureMultiProtocolRtlsPatch();
}

#ifndef _MULTI_PROTOCOL_RTLS_NO_PROG_STATE_VAR
PATCH_FUN_SPEC void cleanMultiProtocolRtlsPatch(void)
{
   bMultiProtocolRtlsPatchEntered = 0;
}
#endif

PATCH_FUN_SPEC void rf_patch_cpe_multi_protocol_rtls(void)
{
   applyMultiProtocolRtlsPatch();
}


//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif //  _RF_PATCH_CPE_MULTI_PROTOCOL_RTLS_H

