/******************************************************************************
*  Filename:       rf_patch_rfe_tof.h
*  Revised:        $Date: 2019-01-31 15:04:59 +0100 (to, 31 jan 2019) $
*  Revision:       $Revision: 18843 $
*
*  Description: RF core RFE patch for time of flight 2Mbps PHY for CC13x2 and CC26x2
*
*  Copyright (c) 2015-2019, Texas Instruments Incorporated
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions are met:
*
*  1) Redistributions of source code must retain the above copyright notice,
*     this list of conditions and the following disclaimer.
*
*  2) Redistributions in binary form must reproduce the above copyright notice,
*     this list of conditions and the following disclaimer in the documentation
*     and/or other materials provided with the distribution.
*
*  3) Neither the name of the ORGANIZATION nor the names of its contributors may
*     be used to endorse or promote products derived from this software without
*     specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
*  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
*  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
*  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
*  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
*  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
*  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
*  POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************/


#ifndef _RF_PATCH_RFE_TOF_H
#define _RF_PATCH_RFE_TOF_H

#include <stdint.h>
#include "../inc/hw_types.h"

#ifndef RFE_PATCH_TYPE
#define RFE_PATCH_TYPE static const uint32_t
#endif

#ifndef PATCH_FUN_SPEC
#define PATCH_FUN_SPEC static inline
#endif

#ifndef RFC_RFERAM_BASE
#define RFC_RFERAM_BASE 0x2100C000
#endif

#ifndef RFE_PATCH_MODE
#define RFE_PATCH_MODE 0
#endif

RFE_PATCH_TYPE patchTofRfe[461] = { 
   0x00006194,
   0x004535aa,
   0x0421a355,
   0x1f40004c,
   0x0000003f,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x40004030,
   0x40034001,
   0x400f4007,
   0x40cf404f,
   0x43cf41cf,
   0x4fcf47cf,
   0x2fcf3fcf,
   0x0fcf1fcf,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x40004030,
   0x40034001,
   0x400f4007,
   0x40cf404f,
   0x6fcf7fcf,
   0x4fcf5fcf,
   0x2fcf3fcf,
   0x0fcf1fcf,
   0x00000000,
   0x00000000,
   0x9100c050,
   0xc0707000,
   0x70009100,
   0x00213182,
   0xb1109131,
   0x81017000,
   0xa100b101,
   0x91323182,
   0x9101b110,
   0x81411011,
   0x40772241,
   0x700006f1,
   0x9150c050,
   0xc0707000,
   0x70009150,
   0x00213182,
   0xb1609181,
   0x10257000,
   0x9100c050,
   0xc140c3f4,
   0x6f031420,
   0x04411031,
   0x22f082a0,
   0x26514094,
   0x3182c022,
   0x91310021,
   0x3963b110,
   0x04411031,
   0x3182c082,
   0x91310021,
   0x3963b110,
   0xc0a21031,
   0x00213182,
   0xb1109131,
   0x31151050,
   0x92551405,
   0x64677000,
   0x1031c2b2,
   0x31610631,
   0x646a02c1,
   0x1031c112,
   0x06713921,
   0x02e13151,
   0x7000646a,
   0x82b16464,
   0x39813181,
   0x646ac0e2,
   0xc1116467,
   0x646ac122,
   0x68c7c470,
   0xc0c2c111,
   0x64e0646a,
   0x700064f3,
   0x82b1647c,
   0x39813181,
   0x6482c182,
   0xc111647f,
   0x6482c0a2,
   0x68d9c470,
   0xc162c331,
   0x64e06482,
   0x700064f3,
   0xb054b050,
   0x80407100,
   0x44ed2240,
   0x40e02200,
   0x8081b060,
   0x44e01e11,
   0xa0547000,
   0x80f0b064,
   0x40e02200,
   0x12407000,
   0xb03290b0,
   0x395382a3,
   0x64ad3953,
   0x68fbc2f0,
   0xc1f18080,
   0xc1510410,
   0x41071c10,
   0xc2216467,
   0x646ac0c2,
   0x647f610b,
   0xc162c441,
   0xce306482,
   0x1280690c,
   0xb03290b0,
   0x64677000,
   0xc0c2c201,
   0x80a0646a,
   0x39403180,
   0xc1016918,
   0x646ac0c2,
   0xc122c101,
   0x82a3646a,
   0x12c064ad,
   0xb03290b0,
   0x647f7000,
   0xc162c401,
   0x80a06482,
   0x39403180,
   0xc301692c,
   0x6482c162,
   0xc0a2c101,
   0x82a36482,
   0x12c064ad,
   0xb03290b0,
   0x64677000,
   0xc081c272,
   0xc122646a,
   0x646ac111,
   0xc111c002,
   0xc062646a,
   0x646ac331,
   0xc111c362,
   0xc302646a,
   0x646ac111,
   0x395382a3,
   0xc3e264ad,
   0x2211646f,
   0xc242414f,
   0x646ac881,
   0xc111c252,
   0xc272646a,
   0x646acee1,
   0xc881c202,
   0xc202646a,
   0x646ac801,
   0x6963c170,
   0x64677000,
   0xc801c242,
   0xc252646a,
   0x646ac011,
   0xc0e1c272,
   0xc002646a,
   0x646ac101,
   0xc301c062,
   0xc122646a,
   0x646ac101,
   0xc101c362,
   0xc302646a,
   0x646ac101,
   0x64ad82a3,
   0x80817000,
   0x418f1e11,
   0xb054b050,
   0x80407100,
   0x41902240,
   0xb064a054,
   0x220180f1,
   0x70004584,
   0x41842200,
   0x6181b060,
   0x72057306,
   0x720e720b,
   0x7100b050,
   0xa050b060,
   0x80928081,
   0x45b32241,
   0xc1f18080,
   0x16300410,
   0x14011101,
   0x61c66c01,
   0x61c661c6,
   0x61c661c6,
   0x61e661c6,
   0x61e661c6,
   0x61c661c6,
   0x809161c6,
   0x0421c0f2,
   0x80823121,
   0x14122a42,
   0x11011632,
   0x6c011421,
   0x61c661cf,
   0x61c661cf,
   0x61c661c6,
   0x61c661c6,
   0x61c861c8,
   0x61cbb0b0,
   0x7306b0b1,
   0xb0307205,
   0x78206198,
   0x78427831,
   0x78547873,
   0x78667885,
   0x92719260,
   0x92939282,
   0x92b592a4,
   0xc01f91a6,
   0x3940924f,
   0x100106f0,
   0x14103110,
   0x61c89250,
   0xcff0b060,
   0x66306793,
   0xb0e16624,
   0xb054b050,
   0x8262b064,
   0x39823182,
   0x64873942,
   0x7100b0e1,
   0x22008040,
   0xb0644621,
   0x225280f2,
   0x22224611,
   0x22324608,
   0x1e02460f,
   0xdfe041f5,
   0x67939342,
   0x61f56511,
   0x663f663a,
   0x80f0b064,
   0x46112250,
   0x663561f5,
   0xcfd061f5,
   0xa0546793,
   0xa050b064,
   0xa052b060,
   0xa053b062,
   0x6565b063,
   0xcfc06511,
   0x720e6793,
   0xcfb061c8,
   0x62116793,
   0x82b16464,
   0x39813181,
   0x646ac0e2,
   0xc1116467,
   0x646ac122,
   0x700064f3,
   0x70006539,
   0x70006511,
   0x64676565,
   0xc0c2c111,
   0x7000646a,
   0xc1016467,
   0x646ac0c2,
   0xc8007000,
   0x81a991b0,
   0x8091b050,
   0x46b02241,
   0x31828262,
   0x39423982,
   0x82626487,
   0x102f06f2,
   0x142f311f,
   0x22d68266,
   0xc1404655,
   0xc5006256,
   0x6f0d1420,
   0x10de396d,
   0x044ec3f4,
   0x3182c082,
   0x396d002e,
   0x3182c0a2,
   0x826a002d,
   0x06fa398a,
   0x31808270,
   0xc00b3980,
   0x10bc180b,
   0x825318ac,
   0x149b1439,
   0x06f08260,
   0x31101001,
   0x81a11410,
   0x140c1410,
   0x46ea22c6,
   0x39408280,
   0x100206f0,
   0x3001c011,
   0x1801c010,
   0x31821802,
   0x26c10021,
   0xb00391e1,
   0xb063b013,
   0x8041b053,
   0x46e12201,
   0x92148204,
   0x1cb58225,
   0x18954e99,
   0x80f091b5,
   0x428b2240,
   0x913d62ae,
   0x913eb110,
   0x80e0b110,
   0x46a32200,
   0x42a322e6,
   0x1895b0e0,
   0x925f91b5,
   0x14f981a9,
   0x225080f0,
   0x224046e1,
   0x637646ae,
   0x6793cfa0,
   0xa052b063,
   0xc0f28280,
   0x10020420,
   0x3001c011,
   0x1801c010,
   0x31821802,
   0x26c10021,
   0x720e91e1,
   0xb01391e1,
   0xb063b003,
   0xb064b053,
   0x7100b054,
   0x22018041,
   0xb06346e1,
   0x80f0b064,
   0x42e12220,
   0x92118201,
   0x18918221,
   0xb03191b1,
   0x674e62c7,
   0x81a9a0e0,
   0x14598255,
   0x7100c080,
   0x6addb063,
   0xb0e6628b,
   0xa053a052,
   0x81b28251,
   0x3d823182,
   0x7000a003,
   0x39478287,
   0x82803987,
   0x06f03980,
   0xc0111002,
   0xc0103001,
   0x18021801,
   0x00213182,
   0x91d126c1,
   0xb012b002,
   0x39408280,
   0x100206f0,
   0x3001c011,
   0x1801c010,
   0x31821802,
   0x26c10021,
   0xb00391e1,
   0xb063b013,
   0x7100b053,
   0xb062a053,
   0x8041b052,
   0x46e12201,
   0x921481f4,
   0x82048225,
   0x4f201cb5,
   0x91b51895,
   0x224080f0,
   0x62ae4311,
   0x92148204,
   0x10408224,
   0x91b01890,
   0x1c751845,
   0x80f04f2d,
   0x43112240,
   0x913d62ae,
   0x913eb110,
   0x80e0b110,
   0x47372200,
   0x433722e6,
   0x91b5b0e0,
   0x81a9925f,
   0x80f014f9,
   0x463f2250,
   0x46ae2240,
   0x674e6355,
   0x81a9a0e0,
   0x14598255,
   0x7100c140,
   0x6b47b062,
   0x80a26311,
   0x61c86487,
   0x39428262,
   0x608706f2,
   0x7100b050,
   0x829061c8,
   0x22018041,
   0x81f446e1,
   0x82259214,
   0x91b51895,
   0x224180f1,
   0x6b5646ae,
   0x318181b1,
   0xdf903d81,
   0x67939341,
   0x22018041,
   0x81f446e1,
   0x82259214,
   0x4b411cc5,
   0x91b51895,
   0x224080f0,
   0x62ae4362,
   0x6793cf80,
   0x80418290,
   0x46e12201,
   0x92148204,
   0x18958225,
   0x80f191b5,
   0x46ae2241,
   0x80416b79,
   0x46e12201,
   0x92148204,
   0x1cc58225,
   0x18954ad7,
   0x80f091b5,
   0x43852240,
   0x933062ae,
   0x22008320,
   0xb3104794,
   0x00007000
};

PATCH_FUN_SPEC void rf_patch_rfe_tof(void)
{
#ifdef __PATCH_NO_UNROLLING
   uint32_t i;
   for (i = 0; i < 461; i++) {
      HWREG(RFC_RFERAM_BASE + 4 * i) = patchTofRfe[i];
   }
#else
   const uint32_t *pS = patchTofRfe;
   volatile unsigned long *pD = &HWREG(RFC_RFERAM_BASE);
   uint32_t t1, t2, t3, t4, t5, t6, t7, t8;
   uint32_t nIterations = 57;

   do {
      t1 = *pS++;
      t2 = *pS++;
      t3 = *pS++;
      t4 = *pS++;
      t5 = *pS++;
      t6 = *pS++;
      t7 = *pS++;
      t8 = *pS++;
      *pD++ = t1;
      *pD++ = t2;
      *pD++ = t3;
      *pD++ = t4;
      *pD++ = t5;
      *pD++ = t6;
      *pD++ = t7;
      *pD++ = t8;
   } while (--nIterations);

   t1 = *pS++;
   t2 = *pS++;
   t3 = *pS++;
   t4 = *pS++;
   t5 = *pS++;
   *pD++ = t1;
   *pD++ = t2;
   *pD++ = t3;
   *pD++ = t4;
   *pD++ = t5;
#endif
}

#endif
