/******************************************************************************
*  Filename:       rf_patch_mce_genfsk.h
*  Revised:        $Date: 2017-05-04 12:39:32 +0200 (Thu, 04 May 2017) $
*  Revision:       $Revision: 17776 $
*
*  Description: RF core patch for CC26x0 Generic FSK
*
*  Copyright (c) 2015-2017, Texas Instruments Incorporated
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions are met:
*
*  1) Redistributions of source code must retain the above copyright notice,
*     this list of conditions and the following disclaimer.
*
*  2) Redistributions in binary form must reproduce the above copyright notice,
*     this list of conditions and the following disclaimer in the documentation
*     and/or other materials provided with the distribution.
*
*  3) Neither the name of the ORGANIZATION nor the names of its contributors may
*     be used to endorse or promote products derived from this software without
*     specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
*  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
*  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
*  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
*  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
*  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
*  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
*  POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************/

#ifndef _RF_PATCH_MCE_GENFSK_H
#define _RF_PATCH_MCE_GENFSK_H

#include <stdint.h>
#include "../inc/hw_types.h"

#ifndef MCE_PATCH_TYPE
#define MCE_PATCH_TYPE static const uint32_t
#endif

#ifndef PATCH_FUN_SPEC
#define PATCH_FUN_SPEC static inline
#endif

#ifndef RFC_MCERAM_BASE
#define RFC_MCERAM_BASE 0x21008000
#endif

#ifndef MCE_PATCH_MODE
#define MCE_PATCH_MODE 0
#endif

MCE_PATCH_TYPE patchGenfskMce[460] = { 
   0x2fcf603c,
   0x030c3f9d,
   0x070c680a,
   0x003f0387,
   0x00fffff0,
   0x0000ff00,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00070003,
   0x00003d1f,
   0x04000000,
   0x0000000f,
   0x000b0387,
   0x004340f4,
   0x80828000,
   0x00000670,
   0x0510091e,
   0x00050054,
   0x3e100200,
   0x00000061,
   0x3030002f,
   0x0000027f,
   0x00000000,
   0x0000aa00,
   0x00000000,
   0x00000000,
   0x00000000,
   0x00000000,
   0x72487220,
   0x7303a32d,
   0x72037305,
   0x73067304,
   0x73767204,
   0xc7c07276,
   0x00018001,
   0x90109001,
   0x90010801,
   0x720d720c,
   0xb0c0720e,
   0xb0f07100,
   0x7218a0c0,
   0x10208132,
   0x06703952,
   0x16300020,
   0x14011101,
   0x60796c01,
   0x60ec607b,
   0x60796352,
   0x60796079,
   0x6079607a,
   0x60ec607b,
   0x60796352,
   0x60796079,
   0x1210607a,
   0x730f7220,
   0x73117310,
   0x00108181,
   0xb0709180,
   0x606f6051,
   0xc030606f,
   0xc1416791,
   0xc470c282,
   0x6f131820,
   0x16116e23,
   0x68811612,
   0x9ab07830,
   0x9ac07840,
   0x9ad07850,
   0x9ae07860,
   0xc5a0c482,
   0x40961820,
   0x6e231203,
   0x68931612,
   0x8160606f,
   0x81409490,
   0x2a703980,
   0x16111001,
   0x84448432,
   0xc0f5c0f3,
   0x1c01c200,
   0xc10040bb,
   0x40b11c10,
   0x10134cb3,
   0x18301803,
   0x1a101a13,
   0x68ae3912,
   0x13f360bb,
   0x13f360bb,
   0xc1001015,
   0x1a151850,
   0x39141a10,
   0xb0d868b9,
   0xb1087100,
   0xb200a0d8,
   0xb003b480,
   0xb002b013,
   0x7229b012,
   0x7100b0d0,
   0x8140b100,
   0x71009290,
   0x8140b100,
   0x44cb22f0,
   0x1c0313f0,
   0x929340d7,
   0x71009492,
   0x9295b100,
   0x71009494,
   0xb0d0b100,
   0x7000a480,
   0xc030a0d1,
   0xc0409760,
   0xb0f19780,
   0x7100b0c1,
   0xa0c1b0f1,
   0xa0037276,
   0x7000a002,
   0x7310730f,
   0x6791c040,
   0x91c0c100,
   0xb4836497,
   0xb0c3b0f3,
   0xa0c37100,
   0x606f64de,
   0xb016b006,
   0xb014b004,
   0xb012b002,
   0x78728400,
   0x81430420,
   0x2a733983,
   0xc1f29473,
   0x31621832,
   0x31511021,
   0x00200012,
   0x10309400,
   0x10011610,
   0x39303121,
   0x41172210,
   0x31501220,
   0x31801003,
   0x16300010,
   0x12029350,
   0x22731204,
   0x8430412a,
   0x87d297c0,
   0x84501a82,
   0x87d497c0,
   0x612c1a84,
   0x41372263,
   0x97c08440,
   0x1a8087d0,
   0x84601402,
   0x87d097c0,
   0x14041a80,
   0x84406143,
   0x041078a1,
   0x87d297c0,
   0x84601a42,
   0x041078a1,
   0x87d497c0,
   0x31521a44,
   0x39633154,
   0x16130633,
   0x38343832,
   0x39823182,
   0x00423184,
   0x78109572,
   0x90509030,
   0x90407820,
   0xb2059060,
   0x83038ae2,
   0xc00c9302,
   0x8140c00b,
   0x39803180,
   0x81413940,
   0x0431c0f3,
   0x1441c014,
   0x1412c002,
   0x31226965,
   0xc010847d,
   0x312d140d,
   0x8ace142d,
   0x311e318e,
   0x8ac9397e,
   0x39793149,
   0x31293949,
   0xb072109a,
   0xb06ea04e,
   0xb06cb011,
   0x7276978a,
   0xa764b764,
   0x9762c662,
   0x66d3c04f,
   0x22f18ab1,
   0x8ad1458b,
   0x458b22f1,
   0x71006231,
   0xb760b073,
   0x220780b7,
   0xa76045c2,
   0x22f18ab1,
   0x2237419c,
   0xb113419c,
   0x223080b0,
   0x61aa4597,
   0x41af22e1,
   0x22508090,
   0xb0f541af,
   0x22208210,
   0x9789418b,
   0xa764b764,
   0x618bb0f6,
   0xb764978d,
   0xb0f6a764,
   0x8ad0618b,
   0x41bb22f0,
   0x41bb2237,
   0xb113b075,
   0x223080b0,
   0xb08745b5,
   0x22d1618b,
   0x80904316,
   0x43162220,
   0x618b6699,
   0xc7f3978f,
   0x31808410,
   0x31833980,
   0x94100030,
   0xa0e3b087,
   0xa0c2b0f2,
   0xa0c5b0f5,
   0xb0c1b0f1,
   0xb110a0c6,
   0x80b0b113,
   0x45d32200,
   0x45d32230,
   0x12607100,
   0xb0f19780,
   0x8961b88f,
   0x18018570,
   0x8a609551,
   0xa4888a71,
   0xc022a487,
   0x1c211801,
   0x14124df3,
   0x61f449f1,
   0x41f41c01,
   0xb4874df3,
   0xb48861f4,
   0xb061b041,
   0x22e08ad0,
   0x821041fc,
   0x45772220,
   0xb04e7100,
   0x80b1b06e,
   0x468b2201,
   0x468b2231,
   0xb0f67276,
   0x31218471,
   0x1410c260,
   0xc7e09780,
   0xc6f09760,
   0xb0f69760,
   0xa0c1b0c6,
   0x8a63b7b0,
   0x8a838a74,
   0x71008a94,
   0x220180b1,
   0x2231468b,
   0x8ab0468b,
   0x462322c0,
   0x22018991,
   0x81c14177,
   0x91c0c000,
   0x81a28470,
   0x91c16a27,
   0x9070c300,
   0xa0e0b201,
   0xa044a0e3,
   0x71007000,
   0xb760b073,
   0x220780b7,
   0x22374650,
   0xa760466e,
   0x22e18ab1,
   0x80904249,
   0x42492250,
   0x8210b0f5,
   0x42312220,
   0xb764978d,
   0xb0f6a764,
   0x22d16231,
   0x80904316,
   0x43162220,
   0x62316699,
   0xb0f2978f,
   0xb0f5a0c2,
   0xb0f1a0c5,
   0xa0c6b0c1,
   0xb113b110,
   0x220080b0,
   0x22304658,
   0x71004658,
   0x97801260,
   0xb88fb0f1,
   0x85708961,
   0x3d803180,
   0x95511801,
   0x8a718a60,
   0x61e5a182,
   0xb0f2978f,
   0xb0f5a0c2,
   0xb0f1a0c5,
   0xa0c6b0c1,
   0xb113b110,
   0x220080b0,
   0x22304676,
   0x71004676,
   0x97801260,
   0xb88fb0f1,
   0x85708961,
   0x18013d80,
   0x8a809551,
   0xb1828a91,
   0xb07361e5,
   0xb760a760,
   0xb072a7b0,
   0xb06ea04e,
   0x8ab0b011,
   0x45c222f0,
   0x46502201,
   0x8ab0626e,
   0x469f22b0,
   0x46d11e3b,
   0x1e7b62a1,
   0xc00b46d1,
   0x8940b889,
   0x3d803180,
   0x3d301610,
   0x80b0140c,
   0x42ad2200,
   0x8ab37000,
   0x06f33983,
   0xcff08ab1,
   0x30310401,
   0x4ec91c1c,
   0x18101200,
   0x4acb1c0c,
   0x220080b0,
   0x700042be,
   0x161210c2,
   0x8ae13c32,
   0x22108320,
   0x62cf42cd,
   0xb0f29301,
   0x101c7000,
   0x100c62ba,
   0x182162ba,
   0x142162c6,
   0x161b62c6,
   0xb0f662c7,
   0xb110b0f1,
   0xb0f5b113,
   0x720cb0f2,
   0x720e720d,
   0xb0e3b0e0,
   0x22f28ab2,
   0xb0c642e4,
   0x62e7b763,
   0x22f08ad0,
   0xb4054307,
   0xb428a404,
   0xcaa0a429,
   0xcaa13180,
   0x94510001,
   0x8ad39461,
   0x39833183,
   0x31808410,
   0x31833980,
   0x94100030,
   0x31508400,
   0x8ad33950,
   0x06f33983,
   0x1834c1f4,
   0x31343184,
   0x94000040,
   0x22e2b089,
   0x8aca4311,
   0x398a394a,
   0x978a312a,
   0xb0c6b0c5,
   0x8ab2b763,
   0x431522d2,
   0x7000b0c2,
   0xa0e0b20f,
   0x978ea0e3,
   0xa764b764,
   0xb110b0f6,
   0x8210b113,
   0x431f22f0,
   0x8002b0f5,
   0xa006a004,
   0x7203a001,
   0xc0507204,
   0x71006791,
   0xb0f6b764,
   0xa20fb0c5,
   0xb0f57100,
   0x7810a0c5,
   0x90029030,
   0x90407820,
   0xb0729060,
   0x66d3a20f,
   0xa764978a,
   0x6184b0f6,
   0x8180b88c,
   0x392489a4,
   0x00043184,
   0xc0609184,
   0x73766791,
   0x72487276,
   0x72027206,
   0x73057204,
   0x606f7306,
   0x91b01300,
   0xc070b32d,
   0xb0f86791,
   0x120064fa,
   0x97801a10,
   0x9760c380,
   0x9760c280,
   0xb0c6a0c1,
   0x22008090,
   0x81544451,
   0x43621e04,
   0xb0f69784,
   0xd0808552,
   0x67919862,
   0x22118991,
   0x8a824378,
   0xe0908a93,
   0x98739862,
   0x637e6791,
   0x8a738a62,
   0x9862e0a0,
   0x67919873,
   0x87818790,
   0x4b8e1c01,
   0x1ef11801,
   0x87814b8c,
   0x97811af1,
   0xb0f67100,
   0x978116f1,
   0x7100a205,
   0xa0c6b0f6,
   0x98506340,
   0x22008840,
   0xb8304792,
   0x00007000
};

PATCH_FUN_SPEC void rf_patch_mce_genfsk(void)
{
#ifdef __PATCH_NO_UNROLLING
   uint32_t i;
   for (i = 0; i < 460; i++) {
      HWREG(RFC_MCERAM_BASE + 4 * i) = patchGenfskMce[i];
   }
#else
   const uint32_t *pS = patchGenfskMce;
   volatile unsigned long *pD = &HWREG(RFC_MCERAM_BASE);
   uint32_t t1, t2, t3, t4, t5, t6, t7, t8;
   uint32_t nIterations = 57;

   do {
      t1 = *pS++;
      t2 = *pS++;
      t3 = *pS++;
      t4 = *pS++;
      t5 = *pS++;
      t6 = *pS++;
      t7 = *pS++;
      t8 = *pS++;
      *pD++ = t1;
      *pD++ = t2;
      *pD++ = t3;
      *pD++ = t4;
      *pD++ = t5;
      *pD++ = t6;
      *pD++ = t7;
      *pD++ = t8;
   } while (--nIterations);

   t1 = *pS++;
   t2 = *pS++;
   t3 = *pS++;
   t4 = *pS++;
   *pD++ = t1;
   *pD++ = t2;
   *pD++ = t3;
   *pD++ = t4;
#endif
}

#endif
